<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Employee Complaint Search</title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        /* Additional styles for customizations */
        body {
            background-color: #f7fafc;
            font-family: 'Inter', sans-serif;
        }

        .card {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
            max-width: 800px;
            margin: 0 auto;
        }

        .input-field {
            padding: 12px;
            border-radius: 8px;
            border: 1px solid #e2e8f0;
            width: 100%;
            font-size: 16px;
            margin-bottom: 20px;
            transition: border 0.3s ease;
        }

        .input-field:focus {
            outline: none;
            border: 1px solid #4299e1;
            box-shadow: 0 0 5px rgba(66, 153, 225, 0.5);
        }

        .submit-btn {
            background-color: #3182ce;
            color: white;
            padding: 12px;
            border-radius: 8px;
            font-weight: 600;
            width: 100%;
            transition: background-color 0.3s ease;
        }

        .submit-btn:hover {
            background-color: #2b6cb0;
        }

        .error-msg {
            background-color: #f44336;
            color: white;
            padding: 12px;
            border-radius: 8px;
            margin-top: 20px;
            text-align: center;
        }

        .no-records {
            background-color: #38a169;
            color: white;
            padding: 12px;
            border-radius: 8px;
            margin-top: 20px;
            text-align: center;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 30px;
        }

        th, td {
            padding: 16px;
            text-align: left;
            border: 1px solid #ddd;
        }

        th {
            background-color: #f7fafc;
            font-weight: 600;
            text-align: center;
        }

        td {
            text-align: center;
        }

        tr:hover {
            background-color: #f1f5f9;
        }

        /* For responsiveness */
        @media (max-width: 768px) {
            table, th, td {
                display: block;
                width: 100%;
            }

            th, td {
                text-align: left;
                padding-left: 20px;
                padding-right: 20px;
            }

            td {
                border-bottom: 1px solid #ddd;
            }
        }
    </style>
</head>
<body class="bg-gray-100 font-sans">

    
    <div class=" py-12 px-4 sm:px-6 lg:px-8">

        <div class="max-w-4xl mx-auto">

            <!-- Search Form -->
            <div class="card">

                <form action="<?php echo e(route('complaints.payment')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="text" name="employee_name" placeholder="First Name" required class="input-field">
                    <input type="text" name="father_name" placeholder="Father's Name" required class="input-field">
                    <input type="text" name="surname" placeholder="Last Name" required class="input-field">
                    <button type="submit" class="submit-btn">💳 Pay ₹100 to 🔍 Search</button>
                </form>

            </div>

            <!-- Error Message -->
            <?php if(session('error')): ?>
                <div class="error-msg">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="mt-10 flex justify-center text-center">
                <div class="mb-4">
                    <a href="<?php echo e(route('home')); ?>" class="inline-block mb-6 px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-gray-800 transition">
                        ← Back to Home
                    </a>
                </div>
            </div>

            <!-- Search Results -->
            <?php if(isset($complaints)): ?>
                <div class="mt-10">
                    <?php if($complaints->count() > 0): ?>
                        <h2 class="text-2xl font-semibold text-gray-700 mb-4 text-center">Search Results</h2>
                        <div class="overflow-x-auto">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Employee ID</th>
                                        <th>Name</th>
                                        <th>Aadhaar</th>
                                        <th>Reason</th>
                                        <th>Termination Letter</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $complaints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $complaint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($complaint->employee_id); ?></td>
                                            <td><?php echo e($complaint->employee_name); ?> <?php echo e($complaint->father_name); ?> <?php echo e($complaint->surname); ?></td>
                                            <td><?php echo e($complaint->aadhar_id); ?></td>
                                            <td><?php echo e($complaint->reason); ?></td>
                                            <td>
                                                <?php if($complaint->termination_letter_path): ?>
                                                <a href="<?php echo e(asset('storage/' . $complaint->termination_letter_path)); ?>"
                                                target="_blank"
                                                class="text-blue-600 hover:underline">
                                                    View Termination Letter
                                                </a>
                                                <?php else: ?>
                                                    <span class="text-gray-500">No file uploaded</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="no-records">
                            No complaints found for this employee.
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>

    </div>


    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <script>
    document.getElementById('pay-button').addEventListener('click', function (e) {
        e.preventDefault();

        // Collect input values
        const employeeName = document.querySelector('input[name="employee_name"]').value;
        const fatherName = document.querySelector('input[name="father_name"]').value;
        const surname = document.querySelector('input[name="surname"]').value;

        if (!employeeName || !fatherName || !surname) {
            alert('Please fill all fields');
            return;
        }

        const options = {
            key: "<?php echo e(env('RAZORPAY_KEY')); ?>", // Replace with your Razorpay key
            amount: 1000, // 10 INR in paise
            currency: "INR",
            name: "Employee Search",
            description: "Pay ₹100 to search complaint",
            handler: function (response) {
                // On successful payment, populate and submit the hidden form
                document.getElementById('hidden-employee-name').value = employeeName;
                document.getElementById('hidden-father-name').value = fatherName;
                document.getElementById('hidden-surname').value = surname;
                document.getElementById('search-form').submit();
            },
            theme: {
                color: "#3182ce"
            }
        };

        const rzp = new Razorpay(options);
        rzp.open();
    });
    </script>



</body>
</html>

<?php echo $__env->make('layouts.guest', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Employee-Management-System-main\resources\views/frontend/pages/company/complaints/search.blade.php ENDPATH**/ ?>