<?php $__env->startSection('content'); ?>
<div class="shadow p-4 d-flex justify-content-between align-items-center ">
    <h4 class="text-uppercase"> Task List</h4>
</div>
<div class="my-5 py-5">

    <div class="d-flex justify-content-end">
        <div class="input-group rounded w-25 mb-5">
            <form action="<?php echo e(route('searchTask')); ?>" method="get">
                <div class="input-group">
                    <input type="text" class="form-control" placeholder="Search..." name="search">
                    <button type="submit" class="input-group-text border-0 bg-transparent" id="search-addon"
                        style="display: inline;">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    
    <div class="w-100 mx-auto">
        <div>
            <table class="table align-middle mb-4 text-center bg-white">
                <thead class="bg-light">
                    <tr>
                        <th>#</th>
                        <th>Employee</th>
                        <th>Department</th>
                        <th>Designation</th>
                        <th>Task Name</th>
                        <th>From Date</th>
                        <th>To Date</th>
                        <th>Total Days</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key + 1); ?></td>
                        <td><?php echo e($task->employee->name); ?></td>
                        <td><?php echo e($task->employee->department->department_name); ?></td>
                        <td><?php echo e($task->employee->designation->designation_name); ?></td>
                        <td><?php echo e($task->task_name); ?></td>
                        <td><?php echo e($task->from_date); ?></td>
                        <td><?php echo e($task->to_date); ?></td>
                        <td><?php echo e($task->total_days); ?></td>
                        
                        <td>
                            <?php if($task->status == 'completed on time'): ?>
                            <span class="text-white fw-bold bg-green rounded-pill p-2">Completed on time</span>
                            <?php elseif($task->status == 'completed in late'): ?>
                            <span class="text-white fw-bold bg-red rounded-pill p-2">Completed Late.</span>
                            <?php else: ?>
                            <span class="text-white fw-bold bg-warning rounded-pill p-2">Pending</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Employee-Management-System-main\resources\views/admin/pages/Task/viewTask.blade.php ENDPATH**/ ?>