<?php $__env->startSection('content'); ?>


<div class="text-center mb-4">
    <h2 style="font-size: 2rem;">Company List</h2>
</div>


<div class="d-flex justify-content-between align-items-start mb-4 flex-wrap">

    
    <form method="GET" action="<?php echo e(route('admin.company.index')); ?>" class="d-flex" style="max-width: 600px;">
        <input type="text" name="search" class="form-control me-2" style="width: 400px;" placeholder="Search by name, email, PAN, contact, or reg. no" value="<?php echo e(request('search')); ?>">

        <button type="submit" class="btn btn-outline-primary">Search</button>
    </form>

    
    <div class="mt-2 mt-md-0">
        <a href="<?php echo e(route('companies.create')); ?>" class="btn btn-primary">
            Add New Company
        </a>
    </div>

</div>



<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<table class="table">
    <thead>
        <tr>
            <th>Name</th><th>Email</th><th>Contact</th><th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($company->name); ?></td>
                <td><?php echo e($company->email); ?></td>
                <td><?php echo e($company->contact); ?></td>
                <td>
                    <a href="<?php echo e(route('admin.company.edit', $company->id)); ?>" class="btn btn-sm btn-warning">Edit</a>
                    <form action="<?php echo e(route('admin.company.destroy', $company->id)); ?>" method="POST" style="display:inline-block;">
                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php if($companies->isEmpty()): ?>
            <tr>
                <td colspan="4" class="text-center">No companies found.</td>
            </tr>
        <?php endif; ?>
    </tbody>

</table>
<div class="d-flex justify-content-center mt-4">
    <?php echo e($companies->links()); ?>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Employee-Management-System-main\resources\views/admin/pages/CompanyInfo/Company/index.blade.php ENDPATH**/ ?>