<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    
    <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-primary mb-3">
        ← Back to Dashboard
    </a>

    <h2 class="mb-4">Registered Companies & Complaints</h2>

    
    <form method="GET" action="<?php echo e(route('complaints.search')); ?>" class="mb-4 row g-2">
        <div class="col-md-3">
            <input type="text" name="employee_name" placeholder="Employee Name" class="form-control">
        </div>
        <div class="col-md-3">
            <input type="text" name="father_name" placeholder="Father Name" class="form-control">
        </div>
        <div class="col-md-3">
            <input type="text" name="surname" placeholder="Surname" class="form-control">
        </div>
        <div class="col-md-3">
            <button type="submit" class="btn btn-success w-100">Search</button>
        </div>
    </form>

    
    <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="card mb-4 shadow-sm">
        <div class="card-body">
            <div class="d-flex justify-content-between">
                <div>
                    <h5 class="card-title"><?php echo e($company->name); ?></h5>
                    <p class="card-text">
                        <strong>Email:</strong> <?php echo e($company->email); ?><br>
                        <strong>Registration:</strong> <?php echo e($company->registration_number); ?><br>
                        <strong>Contact:</strong> <?php echo e($company->contact); ?><br>
                        <strong>Address:</strong> <?php echo e($company->address); ?><br>
                        <strong>Total Complaints:</strong> <?php echo e($company->complaints->count()); ?>

                    </p>
                </div>
                <div class="text-end">
                    <form action="<?php echo e(route('admin.company.destroy', $company->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-danger btn-sm">Delete Company</button>
                    </form>

                    <a href="<?php echo e(route('complaints.create', ['company_id' => $company->id])); ?>" class="btn btn-success btn-sm mt-2">
                        + Add Complaint
                    </a>
                </div>
            </div>

            
            <?php if($company->complaints->isEmpty()): ?>
                <p class="text-muted mt-3">No complaints found.</p>
            <?php else: ?>
                <div class="table-responsive mt-3">
                    <table class="table table-bordered table-sm text-center">
                        <thead class="table-secondary">
                            <tr>
                                <th>#</th>
                                <th>Employee Name</th>
                                <th>Aadhar ID</th>
                                <th>Reason</th>
                                <th>Status</th>
                                <th>Termination Letter</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $company->complaints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $complaint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e($complaint->employee_name); ?> <?php echo e($complaint->father_name); ?> <?php echo e($complaint->surname); ?></td>
                                <td><?php echo e($complaint->aadhar_id); ?></td>
                                <td><?php echo e($complaint->reason); ?></td>
                                <td><?php echo e(ucfirst($complaint->status)); ?></td>
                                <td>
                                    <?php if($complaint->termination_letter_path): ?>
                                        <a href="<?php echo e(asset('storage/' . $complaint->termination_letter_path)); ?>" target="_blank">View Letter</a>
                                    <?php else: ?>
                                        <span class="text-muted">Not Uploaded</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('complaints.edit', $complaint->id)); ?>" class="btn btn-warning btn-sm">Edit</a>

                                    <form action="<?php echo e(route('complaints.destroy', $complaint->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Delete this complaint?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-danger btn-sm">Delete</button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</div>


<?php if(session('success')): ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        Swal.fire({
            icon: 'success',
            title: 'Success',
            text: <?php echo json_encode(session('success'), 15, 512) ?>,
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
        });
    });
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Employee-Management-System-main\resources\views/frontend/pages/Company/complaints/index.blade.php ENDPATH**/ ?>