<?php $__env->startSection('content'); ?>
<div class="shadow p-4 d-flex justify-content-between align-items-center">
    <h4 class="text-uppercase">Leave Request</h4>
</div>
<div class="my-5 py-5">

    <div class="d-flex justify-content-between align-items-center mb-5">
        <div class="input-group rounded w-50">
            <form action="<?php echo e(route('searchLeaveList')); ?>" method="get">
                <div class="input-group">
                    <input type="text" class="form-control" placeholder="Search..." name="search">
                    <button type="submit" class="input-group-text border-0 bg-transparent" id="search-addon">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
            </form>
        </div>
        <a href="allLeaveReport" class="btn btn-danger text-capitalize border-0" data-mdb-ripple-color="dark"><i
                class="fa-regular fa-paste me-1"></i>Report</a>
    </div>

    <table class="table align-middle text-center w-100 bg-white">
        <thead class="bg-light">
            <tr>
                <th>SL NO</th>
                <th>Employee Name</th>
                <th>Department</th>
                <th>Designation</th>
                <th>Leave Type</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Total Days</th>
                <th>Description</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $leaves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $leave): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>
                    <div>
                        <p class="fw-bold mb-1"><?php echo e($key + 1); ?></p>
                    </div>
                </td>
                <td><?php echo e($leave->employee_name); ?></td>
                <td><?php echo e($leave->department_name); ?></td>
                <td><?php echo e($leave->designation_name); ?></td>
                <td><?php echo e($leave->type->leave_type_id); ?></td>
                <td><?php echo e($leave->from_date); ?></td>
                <td><?php echo e($leave->to_date); ?></td>
                <td><?php echo e($leave->total_days); ?></td> <!-- Display total_days -->
                <td><?php echo e($leave->description); ?></td>
                <td>
                    <?php if($leave->status == 'approved'): ?>
                    <span class="text-white fw-bold bg-green rounded-pill p-2">Approved</span>
                    <?php elseif($leave->status == 'rejected'): ?>
                    <span class="text-white fw-bold bg-red rounded-pill p-2">Rejected</span>
                    <?php else: ?>
                    <a class="btn btn-success rounded-pill "
                        href="<?php echo e(route('leave.approve', ['id' => $leave->id])); ?>">Approve</a>
                    <a class="btn btn-danger rounded-pill "
                        href="<?php echo e(route('leave.reject', ['id' => $leave->id])); ?>">Reject</a>
                    <?php endif; ?>
                </td>

            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <div class="w-25 mx-auto mt-4">
        <?php echo e($leaves->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Employee-Management-System-main\resources\views/admin/pages/Leave/leaveList.blade.php ENDPATH**/ ?>