
{{-- frontend pages company complaints index --}}

@extends('admin.master')

@section('content')
<div class="p-6 bg-white">

    {{-- Back to Dashboard --}}
    <a href="{{ route('dashboard') }}"
        class="inline-block mb-6 px-4 py-2 bg-gray-700 text-white rounded-lg hover:bg-gray-800 transition">
        ← Back to Dashboard
    </a>

    <h2 class="text-2xl font-semibold mb-6">Registered Companies & Complaints</h2>

    {{-- Search Form --}}
    <form method="GET" action="{{ route('complaints.search') }}" class="mb-8 grid grid-cols-1 md:grid-cols-4 gap-4">
        <input type="text" name="employee_name" placeholder="Employee Name"
            class="p-2 border border-gray-300 rounded-lg shadow-sm">
        <input type="text" name="father_name" placeholder="Father Name"
            class="p-2 border border-gray-300 rounded-lg shadow-sm">
        <input type="text" name="surname" placeholder="Surname"
            class="p-2 border border-gray-300 rounded-lg shadow-sm">
        <button type="submit"
            class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">
            Search
        </button>
    </form>

    {{-- Company List --}}
    @foreach($companies as $company)
    <div class="mb-10 p-6 bg-gray-100 rounded-lg shadow space-y-4">

        {{-- Company Header + Delete --}}
        <div class="flex justify-between items-start">
            <div>
                <h3 class="text-xl font-bold text-gray-800">{{ $company->name }}</h3>
                <p class="text-sm text-gray-600">Email: {{ $company->email }}</p>
                <p class="text-sm text-gray-600">Registration: {{ $company->registration_number }}</p>
                <p class="text-sm text-gray-600">Contact: {{ $company->contact }}</p>
                <p class="text-sm text-gray-600">Address: {{ $company->address }}</p>
                <p class="text-sm text-blue-600 font-semibold mt-2">Total Complaints: {{ $company->complaints->count() }}</p>
            </div>

            <form action="{{ route('admin.company.destroy', $company->id) }}" method="POST"
                onsubmit="return confirm('Are you sure you want to delete this company and all its complaints?');">
                @csrf
                @method('DELETE')
                <button type="submit"
                    class="px-3 py-1 bg-red-600 text-white rounded hover:bg-red-700 text-sm transition">
                    Delete Company
                </button>

            </form>

            {{-- Add Complaint --}}
            <button type="button"
            class="px-3 py-1 bg-green-600 text-white rounded hover:bg-green-700 text-sm transition""
            onclick="window.location.href='{{ route('complaints.create', ['company_id' => $company->id]) }}'">

            {{-- onclick="window.location.href='{{ route('complaints.create') }}'"> --}}
            + Add Complaint
            </button>

        </div>

        {{-- Complaints Table --}}
        @if($company->complaints->isEmpty())
            <p class="text-sm text-gray-500">No complaints found.</p>
        @else
            <div class="overflow-x-auto">
                <table class="min-w-full text-left border border-gray-300 bg-white text-sm">
                    <thead class="bg-gray-200 text-gray-700">
                        <tr>
                            <th class="p-2 border">#</th>
                            <th class="p-2 border">Employee Name</th>
                            <th class="p-2 border">Aadhar ID</th>
                            <th class="p-2 border">Reason</th>
                            <th class="p-2 border">Status</th>
                            <th class="p-2 border">Termination Letter</th>
                            <th class="p-2 border">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($company->complaints as $index => $complaint)
                        <tr class="hover:bg-gray-50">
                            <td class="p-2 border">{{ $index + 1 }}</td>
                            <td class="p-2 border">{{ $complaint->employee_name }} {{ $complaint->father_name }} {{ $complaint->surname }}</td>
                            <td class="p-2 border">{{ $complaint->aadhar_id }}</td>
                            <td class="p-2 border">{{ $complaint->reason }}</td>
                            <td class="p-2 border">{{ ucfirst($complaint->status) }}</td>
                            <td class="p-2 border">
                                @if($complaint->termination_letter_path)
                                    <a href="{{ asset('storage/' . $complaint->termination_letter_path) }}" target="_blank"
                                        class="text-blue-500 hover:underline">View Letter</a>
                                @else
                                    <span class="text-gray-500">Not Uploaded</span>
                                @endif
                            </td>
                            <td class="p-2 border">
                                <div class="flex gap-2 flex-wrap">

                                    <form action="{{ route('complaints.update', $complaint->id) }}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        @method('PUT')
                                        <a href="{{ route('complaints.edit', $complaint->id) }}">
                                            <button type="button"
                                            class="text-sm px-3 py-1 bg-yellow-500 text-white rounded hover:bg-green-600 transition">
                                                Edit
                                            </button>
                                        </a>
                                    </form>

                                    <form method="POST" action="{{ route('complaints.destroy', $complaint->id) }}" onsubmit="return confirm('Are you sure you want to delete this complaint?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit"
                                            class="text-sm px-3 py-1 bg-red-500 text-white rounded hover:bg-green-600 transition">
                                            Delete
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif

    </div>
    @endforeach

</div>


@if(session('success'))
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            Swal.fire({
                icon: 'success',
                title: 'Success',
                text: @json(session('success')),
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
            });
        });
    </script>
@endif


@endsection



