@extends('admin.master')

@section('content')
{{-- <br>
<h2><b>Company List</b></h2>
<br>
<a href="{{ route('companies.create') }}" class="btn btn-primary">Add New Company</a>
<form method="GET" action="{{ route('admin.company.index') }}" class="mb-3 mt-2" style="max-width: 400px;">
    <div class="input-group">
        <input type="text" name="search" class="form-control" placeholder="Search by name, email, PAN, contact, or reg. number" value="{{ request('search') }}">
        <div class="input-group-append">
            <button class="btn btn-outline-primary" type="submit">Search</button>
        </div>
    </div>
</form> --}}
{{-- Header Section --}}
<div class="text-center mb-4">
    <h2 style="font-size: 2rem;">Company List</h2>
</div>

{{-- Search & Add Button Row --}}
<div class="d-flex justify-content-between align-items-start mb-4 flex-wrap">

    {{-- Search Form (on left) --}}
    <form method="GET" action="{{ route('admin.company.index') }}" class="d-flex" style="max-width: 600px;">
        <input type="text" name="search" class="form-control me-2" style="width: 400px;" placeholder="Search by name, email, PAN, contact, or reg. no" value="{{ request('search') }}">

        <button type="submit" class="btn btn-outline-primary">Search</button>
    </form>

    {{-- Add Button (slightly lower using margin-top) --}}
    <div class="mt-2 mt-md-0">
        <a href="{{ route('companies.create') }}" class="btn btn-primary">
            Add New Company
        </a>
    </div>

</div>



@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

<table class="table">
    <thead>
        <tr>
            <th>Name</th><th>Email</th><th>Contact</th><th>Actions</th>
        </tr>
    </thead>
    <tbody>
        @foreach($companies as $company)
            <tr>
                <td>{{ $company->name }}</td>
                <td>{{ $company->email }}</td>
                <td>{{ $company->contact }}</td>
                <td>
                    <a href="{{ route('admin.company.edit', $company->id) }}" class="btn btn-sm btn-warning">Edit</a>
                    <form action="{{ route('admin.company.destroy', $company->id) }}" method="POST" style="display:inline-block;">
                        @csrf @method('DELETE')
                        <button class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                    </form>
                </td>
            </tr>
        @endforeach

        @if($companies->isEmpty())
            <tr>
                <td colspan="4" class="text-center">No companies found.</td>
            </tr>
        @endif
    </tbody>

</table>
<div class="d-flex justify-content-center mt-4">
    {{ $companies->links() }}
</div>

@endsection
