@extends('admin.master')

@section('content')
<div class="container mt-4">
    <h1 class="mb-4"><b>Create New Company</b></h1>

    <form method="POST" action="{{ route('admin.company.store') }}">
        @csrf

        <!-- Company Name -->
        <div class="form-group mb-3">
            <label>Company Name</label>
            <input type="text" name="name" value="{{ old('name') }}"
                   class="form-control @error('name') is-invalid @enderror" required>
            @error('name')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <!-- Email -->
        <div class="form-group mb-3">
            <label>Email Address</label>
            <input type="email" name="email" value="{{ old('email') }}"
                   class="form-control @error('email') is-invalid @enderror" required>
            @error('email')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <!-- Password -->
        <div class="form-group mb-3">
            <label>Password</label>
            <input type="password" name="password"
                   class="form-control @error('password') is-invalid @enderror" required>
            @error('password')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <!-- Confirm Password -->
        <div class="form-group mb-3">
            <label>Confirm Password</label>
            <input type="password" name="password_confirmation"
                   class="form-control" required>
        </div>

        <!-- Registration Number -->
        <div class="form-group mb-3">
            <label>Registration Number</label>
            <input type="text" name="registration_number" value="{{ old('registration_number') }}"
                   class="form-control @error('registration_number') is-invalid @enderror" required>
            @error('registration_number')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <!-- PAN Number -->
        <div class="form-group mb-3">
            <label>PAN Number</label>
            <input type="text" name="pancard" value="{{ old('pancard') }}"
                class="form-control @error('pancard') is-invalid @enderror" required>
            @error('pancard')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>


        <!-- Address -->
        <div class="form-group mb-3">
            <label>Address</label>
            <textarea name="address" class="form-control @error('address') is-invalid @enderror" required>{{ old('address') }}</textarea>
            @error('address')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <!-- Contact Number -->
        <div class="form-group mb-4">
            <label>Contact Number</label>
            <input type="text" name="contact" value="{{ old('contact') }}"
                   class="form-control @error('contact') is-invalid @enderror" required>
            @error('contact')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <button type="submit" class="btn text-white" style="background-color: #007bff;">Register Company</button>

    </form>
</div>
@endsection
