@extends('Frontend.master')

@section('content')

<!-- ✅ Hero Section -->
<section class="relative h-[500px] md:h-[600px] lg:h-[700px] overflow-hidden w-full bg-gray-900">
    <!-- Background image with overlay -->
    <div class="absolute inset-0 w-full h-full">
        <img src="{{ asset('assests/image/home_evr.jpg') }}" alt="Employee Verification"
            class="w-full h-full object-cover object-center brightness-60" />
        <div class="absolute inset-0 bg-gradient-to-r from-black/80 via-black/50 to-black/30"></div>
        <div class="absolute inset-0 bg-gradient-to-t from-black/70 via-transparent to-transparent"></div>
    </div>

    <!-- Content -->
    <div class="relative z-10 flex flex-col items-start justify-center h-full px-6 sm:px-12 max-w-7xl mx-auto">
        <h1 class="text-4xl sm:text-5xl lg:text-6xl font-extrabold mb-4 text-white">
            Employee <span class="bg-clip-text text-transparent bg-gradient-to-r from-blue-400 to-green-400">Verification</span> Report
        </h1>
        <p class="text-lg sm:text-2xl font-medium text-white/90 leading-snug max-w-3xl">
            Verify before you hire — fast, secure, and reliable.
        </p>
        <a href="#search" class="mt-8 px-8 py-3 bg-gradient-to-r from-blue-600 to-green-500 text-white font-semibold rounded-full shadow-lg hover:shadow-xl transition-all duration-300 inline-flex items-center">
            Search Now <i class="fas fa-arrow-down ml-2"></i>
        </a>
    </div>
</section>


<!-- ✅ Search Section -->
<section id="search" class="relative w-full py-20 bg-gradient-to-b from-gray-100 to-gray-50 overflow-hidden">
    <div class="absolute inset-0 bg-[url('/pattern.svg')] bg-repeat opacity-5 pointer-events-none"></div>
    <div class="w-full max-w-7xl mx-auto px-6 sm:px-12 relative z-10">
        <div class="bg-gradient-to-br from-white via-green-50 to-blue-50 rounded-2xl p-8 sm:p-10 text-center shadow-xl hover:shadow-2xl transition-all duration-300 relative overflow-hidden">
            <div class="absolute -top-20 -right-20 w-40 h-40 bg-blue-200 rounded-full opacity-10"></div>
            <div class="absolute -bottom-20 -left-20 w-60 h-60 bg-green-200 rounded-full opacity-10"></div>

            <h2 class="text-3xl sm:text-4xl font-extrabold text-gray-800 mb-4 relative z-10">
                <span class="bg-clip-text text-transparent bg-gradient-to-r from-blue-600 to-green-600">Search</span> Verification Report
            </h2>
            <p class="text-gray-600 text-base sm:text-lg mb-10 relative z-10">Search and manage complaints with confidence and transparency</p>

            <!-- Search Card -->
            <div class="relative bg-white border border-gray-200 rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 p-8 sm:p-10 backdrop-blur-sm bg-white/90 z-10">
                <div class="absolute -top-10 left-1/2 transform -translate-x-1/2">
                    <div class="w-20 h-20 bg-gradient-to-br from-blue-600 to-green-500 rounded-full flex items-center justify-center shadow-xl ring-4 ring-white">
                        <i class="fa-solid fa-magnifying-glass text-white text-3xl"></i>
                    </div>
                </div>
                <div class="mt-12">
                    @include('frontend.pages.company.complaints.search')
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ✅ Why Choose Us -->
<section class="relative w-full py-20 bg-gradient-to-b from-white to-gray-100 overflow-hidden">
    <div class="absolute inset-0 bg-subtle-pattern pointer-events-none"></div>
    <div class="w-full max-w-7xl mx-auto px-6 sm:px-12 relative z-10">
        <div class="text-center mb-14">
            <h2 class="text-4xl font-extrabold text-gray-900">
                Why <span class="bg-clip-text text-transparent bg-gradient-to-r from-blue-600 to-green-600">Choose Us</span>
            </h2>
            <p class="text-gray-600 text-lg mt-2">Discover what makes our platform powerful and reliable</p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            @foreach([
                ['icon' => 'briefcase', 'title' => 'Our Mission', 'desc' => 'Streamline the verification process by providing real-time employee termination history while upholding privacy and compliance.', 'color' => 'from-blue-50 to-blue-100'],
                ['icon' => 'thumbs-up', 'title' => 'Our Vision', 'desc' => 'Be the most trusted platform for transparent, secure employee status verification that empowers informed hiring.', 'color' => 'from-green-50 to-green-100'],
                ['icon' => 'people-group', 'title' => 'Valid Recruitment', 'desc' => 'Make informed recruitment decisions with access to verified employment and termination history of candidates.', 'color' => 'from-indigo-50 to-indigo-100']
            ] as $feature)
            <div class="bg-gradient-to-br {{ $feature['color'] }} rounded-xl p-8 text-center shadow-md hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2 group">
                <div class="relative inline-block mb-4">
                    <div class="absolute inset-0 bg-gradient-to-br from-blue-500 to-green-500 rounded-full blur-md opacity-20 group-hover:opacity-40 transition-all duration-300 w-24 h-24 mx-auto"></div>
                    <div class="relative w-20 h-20 bg-gradient-to-br from-blue-600 to-green-500 rounded-full flex items-center justify-center mx-auto shadow-lg text-white text-3xl">
                        <i class="fa-solid fa-{{ $feature['icon'] }}"></i>
                    </div>
                </div>
                <h3 class="text-2xl font-bold text-gray-800 mb-3">{{ $feature['title'] }}</h3>
                <p class="text-gray-700 text-md leading-relaxed">{{ $feature['desc'] }}</p>
            </div>
            @endforeach
        </div>
    </div>
</section>

<!-- ✅ Testimonials -->
<section id="testimonials" class="w-full py-16 bg-gradient-to-b from-gray-50 to-white">
    <div class="w-full max-w-7xl mx-auto px-6 sm:px-12">
        <div class="text-center mb-12">
            <div class="inline-flex items-center justify-center w-16 h-16 bg-gradient-to-br from-blue-500 to-green-500 rounded-full shadow-lg mb-4">
                <i class="fas fa-comments text-white text-2xl"></i>
            </div>
            <h2 class="text-3xl font-extrabold text-gray-800">
                What Our <span class="bg-clip-text text-transparent bg-gradient-to-r from-blue-600 to-green-600">Clients Say</span>
            </h2>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="bg-white shadow-lg p-6 rounded-lg relative overflow-hidden group transform hover:-translate-y-2 transition-all duration-300">
                <div class="absolute -top-4 -right-4 w-16 h-16 bg-blue-100 rounded-full opacity-20"></div>
                <div class="relative z-10">
                    <div class="text-yellow-400 mb-3">
                        <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>
                        <i class="fas fa-star"></i><i class="fas fa-star"></i>
                    </div>
                    <p class="text-gray-700 italic">"This platform helped us verify employee histories efficiently, saving us countless hours in the hiring process. The accuracy is unmatched!"</p>
                    <h5 class="mt-4 font-bold text-gray-900">— HR Manager, ABC Corp</h5>
                </div>
            </div>
            <div class="bg-white shadow-lg p-6 rounded-lg relative overflow-hidden group transform hover:-translate-y-2 transition-all duration-300">
                <div class="absolute -bottom-4 -left-4 w-16 h-16 bg-green-100 rounded-full opacity-20"></div>
                <div class="relative z-10">
                    <div class="text-yellow-400 mb-3">
                        <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>
                        <i class="fas fa-star"></i><i class="fas fa-star-half-alt"></i>
                    </div>
                    <p class="text-gray-700 italic">"Very professional service and great customer support! The verification reports are detailed and helped us make better hiring decisions."</p>
                    <h5 class="mt-4 font-bold text-gray-900">— Director, XYZ Ltd</h5>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ✅ Stats -->
<section class="w-full py-16 bg-gradient-to-r from-blue-600 to-green-600 text-white">
    <div class="w-full max-w-7xl mx-auto px-6 sm:px-12">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-6 text-center">
            <div class="p-6">
                <div class="text-4xl font-bold mb-2">10,000+</div>
                <div class="text-sm uppercase tracking-wider">Verifications</div>
            </div>
            <div class="p-6">
                <div class="text-4xl font-bold mb-2">99%</div>
                <div class="text-sm uppercase tracking-wider">Accuracy</div>
            </div>
            <div class="p-6">
                <div class="text-4xl font-bold mb-2">500+</div>
                <div class="text-sm uppercase tracking-wider">Companies</div>
            </div>
            <div class="p-6">
                <div class="text-4xl font-bold mb-2">24/7</div>
                <div class="text-sm uppercase tracking-wider">Support</div>
            </div>
        </div>
    </div>
</section>



<!-- ✅ Styles -->
<style>
    @keyframes pulse {
        0% { transform: scale(1); opacity: 0.2; }
        50% { transform: scale(1.5); opacity: 0.1; }
        100% { transform: scale(2); opacity: 0; }
    }

    @keyframes float {
        0%, 100% { transform: translateY(0); }
        50% { transform: translateY(-5px); }
    }

    .animate-ping {
        animation: pulse 3s infinite ease-in-out;
    }

    .float-animate {
        animation: float 6s ease-in-out infinite;
    }

    .bg-subtle-pattern {
        background-image: radial-gradient(rgba(0,0,0,0.05) 1px, transparent 1px);
        background-size: 20px 20px;
    }

    .whatsapp-button {
    animation: blink-once 0.5s ease-out; /* Blinks once for 0.5s */
    }

    @keyframes blink-once {
        0% { opacity: 1; }
        50% { opacity: 0.3; } /* Halfway fade out */
        100% { opacity: 1; } /* Return to normal */
    }
</style>



@endsection


<!-- WhatsApp Floating Button -->

<a href="https://wa.me/918010830874?text=Hello%20from%20Employee%20Verification%20Report"
   target="_blank"
   class="whatsapp-button fixed bottom-6 right-6 z-50 bg-[#25D366] hover:bg-[#20B858] text-white p-4 rounded-full shadow-lg"
   aria-label="Chat with us on WhatsApp">
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="24" height="24" fill="currentColor">
    <path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L4 480l134.7-35.2c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/>
  </svg>
</a>






























{{-- @extends('Frontend.master')

@section('content')

<!-- ✅ Hero Section with Full Width Background -->
<section class="relative h-[500px] md:h-[600px] lg:h-[700px] overflow-hidden w-full">
    <!-- Full width background with overlay -->
    <div class="absolute inset-0 w-full h-full bg-gray-900">
        <img src="{{ asset('assests/image/home_evr.jpg') }}" alt="Employee Verification"
            class="w-full h-full object-cover object-center brightness-60 scale-105" />

        <!-- Animated gradient overlay -->
        <div class="absolute inset-0 bg-gradient-to-r from-black/80 via-black/50 to-black/30"></div>
        <div class="absolute inset-0 bg-gradient-to-t from-black/70 via-transparent to-transparent"></div>
    </div>

    <!-- Content container with max width -->
    <div class="relative z-20 flex flex-col items-start justify-center h-full px-6 sm:px-12 w-full max-w-7xl mx-auto">
        <h1 class="text-4xl sm:text-5xl lg:text-6xl font-extrabold mb-4 text-white drop-shadow-lg">
            Employee <span class="bg-clip-text text-transparent bg-gradient-to-r from-blue-400 to-green-400">Verification</span> Report
        </h1>
        <p class="text-lg sm:text-2xl font-medium text-white/90 leading-snug drop-shadow-md max-w-3xl">
            Verify before you hire — fast, secure, and reliable.
        </p>
        <div class="mt-8">
            <a href="#search" class="px-8 py-3 bg-gradient-to-r from-blue-600 to-green-500 text-white font-semibold rounded-full shadow-lg hover:shadow-xl transition-all hover:scale-105 transform duration-300 inline-flex items-center">
                Search Now <i class="fas fa-arrow-down ml-2"></i>
            </a>
        </div>
    </div>
</section>

<!-- ✅ Search Section with Full Width Background -->
<section id="search" class="w-full py-20 bg-gradient-to-b from-gray-100 to-gray-50">
    <div class="w-full max-w-7xl mx-auto px-6 sm:px-12">
        <div class="bg-gradient-to-br from-white via-green-50 to-blue-50 rounded-2xl p-8 sm:p-10 text-center shadow-xl hover:shadow-2xl transition-all duration-300 relative overflow-hidden">
            <!-- Decorative elements -->
            <div class="absolute -top-20 -right-20 w-40 h-40 bg-blue-200 rounded-full opacity-10"></div>
            <div class="absolute -bottom-20 -left-20 w-60 h-60 bg-green-200 rounded-full opacity-10"></div>

            <h2 class="text-3xl sm:text-4xl font-extrabold text-gray-800 mb-4 relative z-10">
                <span class="bg-clip-text text-transparent bg-gradient-to-r from-blue-600 to-green-600">Search</span> Verification Report
            </h2>
            <p class="text-gray-600 text-base sm:text-lg mb-10 relative z-10">Search and manage complaints with confidence and transparency</p>

            <!-- Search Card -->
            <div class="relative bg-white border border-gray-200 rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 p-8 sm:p-10 backdrop-blur-sm bg-white/90 z-10">
                <div class="absolute -top-10 left-1/2 transform -translate-x-1/2">
                    <div class="w-20 h-20 bg-gradient-to-br from-blue-600 to-green-500 rounded-full flex items-center justify-center shadow-xl ring-4 ring-white">
                        <i class="fa-solid fa-magnifying-glass text-white text-3xl"></i>
                    </div>
                </div>
                <div class="mt-12">
                    @include('frontend.pages.company.complaints.search')
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ✅ Why Choose Us with Full Width Background -->
<section class="w-full py-20 bg-gradient-to-b from-white to-gray-100 relative overflow-hidden">
    <!-- Background pattern -->
    <div class="absolute inset-0 opacity-5 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxjaXJjbGUgZmlsbD0iIzAwMCIgY3g9IjIwIiBjeT0iMjAiIHI9IjEiLz48L2c+PC9zdmc+')]"></div>

    <div class="w-full max-w-7xl mx-auto px-6 sm:px-12">
        <div class="text-center mb-14 relative z-10">
            <h2 class="text-4xl font-extrabold text-gray-900">
                Why <span class="bg-clip-text text-transparent bg-gradient-to-r from-blue-600 to-green-600">Choose Us</span>
            </h2>
            <p class="text-gray-600 text-lg mt-2">Discover what makes our platform powerful and reliable</p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            @foreach([
                ['icon' => 'briefcase', 'title' => 'Our Mission', 'desc' => 'Streamline the verification process by providing real-time employee termination history while upholding privacy and compliance.', 'color' => 'from-blue-50 to-blue-100'],
                ['icon' => 'thumbs-up', 'title' => 'Our Vision', 'desc' => 'Be the most trusted platform for transparent, secure employee status verification that empowers informed hiring.', 'color' => 'from-green-50 to-green-100'],
                ['icon' => 'people-group', 'title' => 'Valid Recruitment', 'desc' => 'Make informed recruitment decisions with access to verified employment and termination history of candidates.', 'color' => 'from-indigo-50 to-indigo-100']
            ] as $feature)
            <div class="bg-gradient-to-br {{ $feature['color'] }} rounded-xl p-8 text-center shadow-md hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2 group">
                <div class="relative inline-block mb-4">
                    <div class="absolute inset-0 bg-gradient-to-br from-blue-500 to-green-500 rounded-full blur-md opacity-20 group-hover:opacity-40 transition-all duration-300 w-24 h-24 mx-auto"></div>
                    <div class="relative w-20 h-20 bg-gradient-to-br from-blue-600 to-green-500 rounded-full flex items-center justify-center mx-auto shadow-lg text-white text-3xl">
                        <i class="fa-solid fa-{{ $feature['icon'] }}"></i>
                    </div>
                </div>
                <h3 class="text-2xl font-bold text-gray-800 mb-3">{{ $feature['title'] }}</h3>
                <p class="text-gray-700 text-md leading-relaxed">{{ $feature['desc'] }}</p>
            </div>
            @endforeach
        </div>
    </div>
</section>

<!-- ✅ Testimonials with Full Width Background -->
<section id="testimonials" class="w-full py-16 bg-gradient-to-b from-gray-50 to-white">
    <div class="w-full max-w-7xl mx-auto px-6 sm:px-12">
        <div class="text-center mb-12">
            <div class="inline-flex items-center justify-center w-16 h-16 bg-gradient-to-br from-blue-500 to-green-500 rounded-full shadow-lg mb-4">
                <i class="fas fa-comments text-white text-2xl"></i>
            </div>
            <h2 class="text-3xl font-extrabold text-gray-800">
                What Our <span class="bg-clip-text text-transparent bg-gradient-to-r from-blue-600 to-green-600">Clients Say</span>
            </h2>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="bg-white shadow-lg p-6 rounded-lg relative overflow-hidden group transform hover:-translate-y-2 transition-all duration-300">
                <div class="absolute -top-4 -right-4 w-16 h-16 bg-blue-100 rounded-full opacity-20"></div>
                <div class="relative z-10">
                    <div class="text-yellow-400 mb-3">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="text-gray-700 italic">"This platform helped us verify employee histories efficiently, saving us countless hours in the hiring process. The accuracy is unmatched!"</p>
                    <h5 class="mt-4 font-bold text-gray-900">— HR Manager, ABC Corp</h5>
                </div>
            </div>
            <div class="bg-white shadow-lg p-6 rounded-lg relative overflow-hidden group transform hover:-translate-y-2 transition-all duration-300">
                <div class="absolute -bottom-4 -left-4 w-16 h-16 bg-green-100 rounded-full opacity-20"></div>
                <div class="relative z-10">
                    <div class="text-yellow-400 mb-3">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star-half-alt"></i>
                    </div>
                    <p class="text-gray-700 italic">"Very professional service and great customer support! The verification reports are detailed and helped us make better hiring decisions."</p>
                    <h5 class="mt-4 font-bold text-gray-900">— Director, XYZ Ltd</h5>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ✅ Stats Section with Full Width Background -->
<section class="w-full py-16 bg-gradient-to-r from-blue-600 to-green-600 text-white">
    <div class="w-full max-w-7xl mx-auto px-6 sm:px-12">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-6 text-center">
            <div class="p-6">
                <div class="text-4xl font-bold mb-2">10,000+</div>
                <div class="text-sm uppercase tracking-wider">Verifications</div>
            </div>
            <div class="p-6">
                <div class="text-4xl font-bold mb-2">99%</div>
                <div class="text-sm uppercase tracking-wider">Accuracy</div>
            </div>
            <div class="p-6">
                <div class="text-4xl font-bold mb-2">500+</div>
                <div class="text-sm uppercase tracking-wider">Companies</div>
            </div>
            <div class="p-6">
                <div class="text-4xl font-bold mb-2">24/7</div>
                <div class="text-sm uppercase tracking-wider">Support</div>
            </div>
        </div>
    </div>
</section>

<style>
    /* Smooth transitions */
    section {
        transition: background-color 0.5s ease;
    }

    /* Subtle pattern for backgrounds */
    .bg-pattern {
        background-image: radial-gradient(rgba(0,0,0,0.05) 1px, transparent 1px);
        background-size: 20px 20px;
    }

    /* Gradient text for emphasis */
    .gradient-text {
        background-clip: text;
        -webkit-background-clip: text;
        color: transparent;
    }

    /* Hover effects */
    .hover-scale {
        transition: transform 0.3s ease;
    }
    .hover-scale:hover {
        transform: scale(1.02);
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .hero-height {
            height: 400px;
        }
    }
</style>

@endsection --}}



























{{-- @extends('Frontend.master')

@section('content')

    <!-- ✅ Hero Section -->
    <section class="relative h-[450px] md:h-[550px] lg:h-[600px] overflow-hidden">
    <img src="{{ asset('assests/image/home_evr.jpg') }}" alt="Employee Verification"
        class="absolute inset-0 w-full h-full object-cover object-center brightness-60" />
    <!-- Gradient overlay - behind text -->
    <div class="absolute inset-0 bg-gradient-to-r from-black/70 to-transparent z-10"></div>

    <!-- Text container -->
        <div class="relative z-20 flex flex-col items-start justify-center h-full text-left px-6 sm:px-12 w-full max-w-full">
        <h1 class="text-2xl sm:text-4xl lg:text-5xl xl:text-6xl font-extrabold mb-4 leading-tight text-white drop-shadow-lg whitespace-nowrap overflow-hidden text-ellipsis">
            Employee Verification Report
        </h1>
        <p class="text-xl sm:text-2xl md:text-3xl font-semibold text-white leading-snug md:leading-normal drop-shadow-md max-w-5xl">
            Verify before you hire — fast, secure, and reliable.
        </p>
        </div>
    </section>


    <!-- ✅ Enhanced Verification Section -->
    <section class="bg-gray-100 py-16">
        <div class="bg-gradient-to-br from-green-50 to-green-100 rounded-xl p-6 text-center shadow hover:shadow-xl transition">
            <h2 class="text-3xl sm:text-4xl font-bold text-gray-800 mb-4">Search Verification Report</h2>
            <p class="text-gray-600 text-base sm:text-lg mb-12">
                Search and manage complaints with confidence and transparency
            </p>

            <!-- Fancy Card -->
            <div class="relative bg-gradient-to-br from-white via-gray-50 to-white border border-gray-200 rounded-2xl shadow-2xl hover:shadow-3xl transition-all duration-300 p-10">
                <div class="absolute -top-8 left-1/2 transform -translate-x-1/2">
                    <div class="w-16 h-16 bg-blue-600 rounded-full flex items-center justify-center shadow-xl ring-4 ring-white">
                        <i class="fa-solid fa-magnifying-glass text-white text-2xl"></i>
                    </div>
                </div>
                <div class="mt-10">
                    @include('frontend.pages.company.complaints.search')
                </div>
            </div>
        </div>
    </section>

    <!-- ✅ Why Choose Us Section -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="text-center mb-12">
                <h2 class="text-4xl font-bold text-gray-800">Why Choose Us</h2>
                <p class="text-gray-600 mt-2">Discover what makes our platform powerful and reliable</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Mission Card -->
                <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-xl p-6 text-center shadow hover:shadow-xl transition">
                    <div class="text-blue-600 text-6xl mb-4">
                        <i class="fa-solid fa-briefcase"></i>
                    </div>
                    <h3 class="text-2xl font-semibold mb-3">Our Mission</h3>
                    <p class="text-gray-700 text-md leading-relaxed">
                        Streamline the verification process by providing real-time employee termination history while upholding privacy and compliance.
                    </p>
                </div>

                <!-- Vision Card -->
                <div class="bg-gradient-to-br from-green-50 to-green-100 rounded-xl p-6 text-center shadow hover:shadow-xl transition">
                    <div class="text-blue-600 text-6xl mb-4">
                        <i class="fa-solid fa-thumbs-up"></i>
                    </div>
                    <h3 class="text-2xl font-semibold mb-3">Our Vision</h3>
                    <p class="text-gray-700 text-md leading-relaxed">
                        Be the most trusted platform for transparent, secure employee status verification that empowers informed hiring.
                    </p>
                </div>

                <!-- Recruitment Card -->
                <div class="bg-gradient-to-br from-indigo-50 to-indigo-100 rounded-xl p-6 text-center shadow hover:shadow-xl transition">
                    <div class="text-blue-600 text-6xl mb-4">
                        <i class="fa-solid fa-people-group"></i>
                    </div>
                    <h3 class="text-2xl font-semibold mb-3">Valid Recruitment</h3>
                    <p class="text-gray-700 text-md leading-relaxed">
                        Make informed recruitment decisions with access to verified employment and termination history of candidates.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- ✅ Testimonials Info Section -->
    <section id="testimonials" class="bg-light py-5">
        <div class="container">
           <div class="d-flex justify-content-center align-items-center mb-4">
                <i class="fas fa-comments fa-2x text-primary me-3"></i>
                <h2 class="section-title mb-0">Testimonials</h2>
            </div>

            <div class="row">
                <div class="col-md-6 mb-4">
                    <div class="card p-4 shadow-sm">
                        <p>"This platform helped us verify employee histories efficiently."</p>
                        <h5 class="mt-3 mb-0">— HR Manager, ABC Corp</h5>
                    </div>
                </div>
                <div class="col-md-6 mb-4">
                    <div class="card p-4 shadow-sm">
                        <p>"Very professional service and great customer support!"</p>
                        <h5 class="mt-3 mb-0">— Director, XYZ Ltd</h5>
                    </div>
                </div>
            </div>
        </div>
    </section>


@endsection
 --}}
