<style>
    .footer {
        background: linear-gradient(135deg, #2c3e50 0%, #3498db 100%);
        color: white;
        padding-top: 3rem;
        padding-bottom: 2rem;
        position: relative;
        overflow: hidden;
        text-align: center;
    }

    /* Animated background effect */
    .footer::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(45deg, rgba(255,255,255,0.1) 25%, transparent 25%),
                    linear-gradient(-45deg, rgba(255,255,255,0.1) 25%, transparent 25%);
        background-size: 60px 60px;
        animation: moveBackground 15s linear infinite;
        opacity: 0.1;
    }

    @keyframes moveBackground {
        0% { background-position: 0 0; }
        100% { background-position: 60px 60px; }
    }

    .footer-title {
        font-size: 1.4rem;
        margin-bottom: 1.5rem;
        position: relative;
        display: inline-block;
        padding-bottom: 10px;
    }

    .footer-title::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        width: 50%;
        height: 3px;
        background: #00aced;
        transform: translateX(-50%) scaleX(0);
        transform-origin: center;
        animation: titleLine 1s forwards;
    }

    @keyframes titleLine {
        to { transform: translateX(-50%) scaleX(1); }
    }

    .tiny-footer {
        background: rgba(0,0,0,0.2);
        padding: 1.5rem 0;
        margin-top: 2rem;
        text-align: center;
    }

    .tiny-footer p {
        margin: 0;
        font-size: 1.1rem; /* Increased from 0.9rem */
        letter-spacing: 0.5px;
        line-height: 1.5;
    }

    .tiny-footer a {
        font-size: 1.2rem; /* Slightly larger than regular text */
        font-weight: 600;
        color: #00aced;
        transition: all 0.3s ease;
    }

    .tiny-footer a:hover {
        color: #ffffff;
        text-shadow: 0 0 10px rgba(255,255,255,0.5);
    }

    /* Make copyright symbol more visible */
    .tiny-footer .copyright-symbol {
        font-size: 1.3rem;
        margin: 0 3px;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .tiny-footer p {
            font-size: 1rem;
            padding: 0 15px;
        }

        .tiny-footer a {
            font-size: 1.1rem;
        }
    }

    .footer a {
        color: #ffffff;
        text-decoration: none;
        font-weight: 500;
        transition: all 0.3s ease;
        position: relative;
        display: inline-block;
    }

    .footer a::after {
        content: '';
        position: absolute;
        bottom: -2px;
        left: 0;
        width: 100%;
        height: 1px;
        background: #00aced;
        transform: scaleX(0);
        transition: transform 0.3s ease;
    }

    .footer a:hover {
        color: #00aced;
        transform: translateY(-2px);
    }

    .footer a:hover::after {
        transform: scaleX(1);
    }

    .contact-info {
        max-width: 600px;
        margin: 0 auto;
    }

    .contact-info p {
        margin-bottom: 1rem;
        display: flex;
        align-items: center;
        justify-content: center;
        opacity: 0;
        animation: fadeIn 0.5s forwards;
    }

    @keyframes fadeIn {
        to { opacity: 1; }
    }

    .contact-info i {
        margin-right: 10px;
        color: #00aced;
        font-size: 1.2rem;
    }

    .ft-social {
        display: flex;
        justify-content: center;
        gap: 20px;
        margin-top: 2rem;
    }

    .ft-social a {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: rgba(255,255,255,0.1);
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
    }

    .ft-social a:hover {
        background: #00aced;
        transform: translateY(-5px) rotate(360deg);
    }

    .ft-social i {
        font-size: 20px;
    }

    .tiny-footer {
        background: rgba(0,0,0,0.2);
        padding: 1rem 0;
        margin-top: 2rem;
        text-align: center;
    }

    .tiny-footer p {
        margin: 0;
        font-size: 0.9rem;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .footer {
            padding: 2rem 1rem;
        }

        .contact-info p {
            flex-direction: column;
            text-align: center;
        }

        .contact-info i {
            margin: 0 0 0.5rem 0;
        }

        .ft-social {
            gap: 15px;
        }

        .ft-social a {
            width: 35px;
            height: 35px;
        }
    }
</style>

<div class="footer">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10">
                <h5 class="footer-title">Get In Touch</h5>

                <div class="contact-info">

                    <p style="animation-delay: 0.4s;">
                        <i class="fa fa-phone"></i>
                        <a href="tel:+918010830874">+91 8010830874</a>
                    </p>
                    <p style="animation-delay: 0.6s;">
                        <i class="fa fa-envelope"></i>
                        <a href="mailto:atmttest2@gmail.com">atmttest2@gmail.com</a>
                    </p>
                     <p style="animation-delay: 0.2s;">
                        <i class="fa fa-map-marker"></i>
                        301, 302, Siddhivinayak Homes, Lakadganj, Nagpur-440008, Maharashtra, India
                    </p>
                </div>

                <div class="ft-social">
                    <a href="#" aria-label="Facebook"><i class="fa fa-facebook"></i></a>
                    <a href="#" aria-label="Twitter"><i class="fa fa-twitter"></i></a>
                    <a href="#" aria-label="LinkedIn"><i class="fa fa-linkedin"></i></a>
                    <a href="#" aria-label="Google Plus"><i class="fa fa-google-plus"></i></a>
                </div>
            </div>
        </div>
    </div>

   <div class="tiny-footer">
        <div class="container">
            <p>
                Copyright <span class="copyright-symbol">&copy;</span> 2025 Employee Verification Report | Built with by
                <a href="#" class="font-weight-bold">Aarush GOC Pvt Ltd</a>
            </p>
        </div>
    </div>
</div>















{{-- <style>
    .footer a {
        color: #ffffff;
        text-decoration: underline; /* Underline by default = clear it's a link */
        font-weight: 500;
        transition: color 0.3s ease;
    }

    .footer a:hover {
        color: #00aced; /* Highlight on hover */
        text-decoration: underline;
    }

    .footer .footer-title {
        font-size: 1.2rem;
        margin-bottom: 1rem;
        border-bottom: 2px solid #00aced;
        display: inline-block;
        padding-bottom: 5px;
    }

    .footer ul li {
        margin-bottom: 8px;
    }

    .ft-social a {
        font-size: 18px;
        cursor: pointer;
    }
</style>

<div class="footer bg-dark text-white pt-5 pb-4">
    <div class="container">
        <div class="row">

            <!-- Contact Info -->
            <div class="col-lg-4 col-md-6 mb-4">
                <h5 class="footer-title mb-3">Contact Info</h5>
                <p><i class="fa fa-map-marker mr-2"></i> 301, 302, Siddhivinayak Homes, Lakadganj, Nagpur-440008, Maharashtra, India</p>
                <p><i class="fa fa-phone mr-2"></i> +91 8010830874</p>
                <p><i class="fa fa-envelope mr-2"></i> atmttest2@gmail.com</p>

                <div class="ft-social mt-3">
                    <a href="https://www.facebook.com/poonammohod" class="text-white mr-3"><i class="fa fa-facebook"></i></a>
                    <a href="https://twitter.com/AKHS87" class="text-white mr-3"><i class="fa fa-twitter"></i></a>
                    <a href="https://www.linkedin.com/in/akikhossain/" class="text-white mr-3"><i class="fa fa-linkedin"></i></a>
                    <a href="#" class="text-white"><i class="fa fa-google-plus"></i></a>
                </div>
            </div>

            <!-- Company Links -->
            <div class="col-lg-4 col-md-6 mb-4">
                <h5 class="footer-title mb-3">Company</h5>
                <div class="row">
                    <div class="col-6">
                        <ul class="list-unstyled">
                            <li><a href="{{ route('home') }}" class="text-white">Home</a></li>
                            <li><a href="{{ route('client.list') }}" class="text-white">Clients</a></li>
                            <li><a href="{{ route('services') }}" class="text-white">Services</a></li>
                        </ul>
                    </div>
                    <div class="col-6">
                        <ul class="list-unstyled">
                            <li><a href="{{ route('contacts') }}" class="text-white">Contact Us</a></li>
                            <li><a href="#" class="text-white">Job List</a></li>
                            <li><a href="#" class="text-white">Notice</a></li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Logo -->
            <div class="col-lg-4 col-md-12 text-center mb-4">
                <img class="img-fluid rounded shadow" style="max-height: 100px;"
                     src="https://i.ibb.co/w7GnVBw/4101adc6-07bf-42cd-9723-b7baa76d9bef.jpg"
                     alt="Company Logo">
            </div>
        </div>
    </div>

    <!-- Tiny Footer -->
    <div class="tiny-footer bg-secondary text-center py-3 mt-4">
        <p class="mb-0 text-white">
            &copy; 2025 Employee Management System | Built by
            <a href="https://github.com/poonammohod" target="_blank" class="text-light font-weight-bold">Aarush GOC Pvt Ltd</a>
        </p>
    </div>
</div> --}}
