@extends('Frontend.master')
@section('content')

<div class="contact-page">
    <!-- Contact Form Section -->
    <section class="contact-form-section py-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="contact-form-wrapper p-4 p-lg-5 animate__animated animate__fadeInUp">
                        <h2 class="gradient-text text-4xl w-full text-white font-extrabold bg-gradient-to-r from-blue-600 to-green-500">
                        How Can We Help You?</h2>

                        <form action="{{ route('contactStore') }}" method="post" class="needs-validation" novalidate>
                            @csrf
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <label for="name" class="form-label">Name</label>
                                    <input type="text" class="form-control" id="name" name="name" required>
                                    <div class="invalid-feedback">Please provide your name.</div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <label for="email" class="form-label">Email</label>
                                    <input type="email" class="form-control" id="email" name="email" required>
                                    <div class="invalid-feedback">Please provide a valid email.</div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <label for="phone" class="form-label">Phone</label>
                                    <input type="tel" class="form-control" id="phone" name="phone" required>
                                    <div class="invalid-feedback">Please provide your phone number.</div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <label for="subject" class="form-label">Subject</label>
                                    <input type="text" class="form-control" id="subject" name="subject">
                                </div>
                            </div>
                            <div class="mb-4">
                                <label for="message" class="form-label">Message</label>
                                <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
                                <div class="invalid-feedback">Please enter your message.</div>
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary btn-lg px-5 py-3">
                                    <i class="fas fa-paper-plane me-2"></i> Send Message
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Google Map -->
    <div class="container my-5 animate__animated animate__fadeIn">
         <h2 class="gradient-text text-4xl w-full text-white font-extrabold bg-gradient-to-r from-blue-600 to-green-500">
                        Our Location</h2>
        <div class="rounded overflow-hidden shadow-sm" style="height: 400px;">

            <iframe
                src="https://www.google.com/maps?q=542F%2BRW%20Nagpur,%20Maharashtra&output=embed"
                width="100%"
                height="100%"
                frameborder="0"
                style="border:0;"
                allowfullscreen=""
                loading="lazy"
                referrerpolicy="no-referrer-when-downgrade">
            </iframe>
        </div>
    </div>
</div>

<!-- CSS Styles -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" rel="stylesheet"/>

<style>
    :root {
        --primary: #0d6efd;
        --primary-light: rgba(13, 110, 253, 0.1);
    }

    .contact-page {
        overflow-x: hidden;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .contact-form-section {
        background: linear-gradient(-45deg, #e3f2fd, #e0f7fa, #fce4ec, #f3e5f5);
        background-size: 400% 400%;
        animation: gradientBG 12s ease infinite;
        position: relative;
    }

    @keyframes gradientBG {
        0% { background-position: 0% 50%; }
        50% { background-position: 100% 50%; }
        100% { background-position: 0% 50%; }
    }

    .contact-form-wrapper {
        background: #ffffff;
        border-top: 4px solid var(--primary);
        border-radius: 15px;
        box-shadow: 0 15px 25px rgba(0, 0, 0, 0.1);
    }

    .contact-title {
        font-weight: 700;
        color: #2c3e50;
        position: relative;
        padding-bottom: 15px;
    }

    .contact-title::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 70px;
        height: 3px;
        background: var(--primary);
    }

    .form-control {
        border-radius: 10px;
        transition: border-color 0.3s ease;
        border: 1px solid #ced4da;
    }

    .form-control:focus {
        border-color: var(--primary);
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    }

    .btn-primary {
        background: var(--primary);
        border: none;
        border-radius: 50px;
        transition: all 0.3s ease;
    }

    .btn-primary:hover {
        background-color: #09009f;
        transform: translateY(-2px);
        box-shadow: 0 6px 16px rgba(13, 110, 253, 0.3);
    }

    .invalid-feedback {
        color: #00ff95;
        font-size: 0.875em;
    }

    h2 {
    font-size: 28px;
    font-weight: 800;
    margin: 0;
    }

    h2.gradient-text {
    background: -webkit-linear-gradient(45deg, #09009f, #00ff95 80%);
    -webkit-background-clip: text; /* apply background clip */
    -webkit-text-fill-color: transparent;
    }

    @media (max-width: 767.98px) {
        .contact-form-wrapper {
            padding: 2rem;
        }

        .contact-title {
            font-size: 1.75rem;
        }
    }
</style>

<script>
    // Bootstrap validation
    (function () {
        'use strict';
        window.addEventListener('load', function () {
            var forms = document.getElementsByClassName('needs-validation');
            Array.prototype.filter.call(forms, function (form) {
                form.addEventListener('submit', function (event) {
                    if (form.checkValidity() === false) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        }, false);
    })();
</script>
@endsection























{{-- @extends('Frontend.master')
@section('content')

<div class="contact-page">
    <!-- Contact Form Section -->
    <section class="contact-form-section py-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10 col-md-10 col-sm-12">
                    <div class="contact-form-wrapper p-4 p-lg-5">
                        <h1 class="contact-title mb-4 text-center">How Can We Help You?</h1>

                        <form action="{{ route('contactStore') }}" method="post" class="needs-validation" novalidate>
                            @csrf
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-group">
                                        <label for="name" class="form-label">Name</label>
                                        <input type="text" class="form-control" id="name" name="name" required>
                                        <div class="invalid-feedback">
                                            Please provide your name.
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-group">
                                        <label for="email" class="form-label">Email</label>
                                        <input type="email" class="form-control" id="email" name="email" required>
                                        <div class="invalid-feedback">
                                            Please provide a valid email.
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-group">
                                        <label for="phone" class="form-label">Phone</label>
                                        <input type="tel" class="form-control" id="phone" name="phone" required>
                                        <div class="invalid-feedback">
                                            Please provide your phone number.
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-group">
                                        <label for="subject" class="form-label">Subject</label>
                                        <input type="text" class="form-control" id="subject" name="subject">
                                    </div>
                                </div>
                            </div>

                            <div class="mb-4">
                                <div class="form-group">
                                    <label for="message" class="form-label">Message</label>
                                    <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
                                    <div class="invalid-feedback">
                                        Please enter your message.
                                    </div>
                                </div>
                            </div>

                            <div class="text-center">
                                <button type="submit" class="btn btn-primary btn-lg px-5 py-3">
                                    <i class="fas fa-paper-plane me-2"></i> Send Message
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- Google Map -->
    <div class="container my-5">
        <h2 class="text-center mb-4">Our Location</h2>
        <div class="rounded overflow-hidden shadow-sm" style="height: 400px;">
            <iframe
                src="https://www.google.com/maps?q=542F%2BRW%20Nagpur,%20Maharashtra&output=embed"
                width="100%"
                height="100%"
                frameborder="0"
                style="border:0;"
                allowfullscreen=""
                loading="lazy"
                referrerpolicy="no-referrer-when-downgrade">
            </iframe>
        </div>
    </div>

</div>

<style>
    :root {
        --primary: #0d6efd;
        --primary-light: rgba(13, 110, 253, 0.1);
    }

    .contact-page {
        overflow-x: hidden;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Remove duplicate .contact-form-section declarations */
    .contact-form-section {
        background: url('/images/contact-bg.jpg') no-repeat center center;
        background-size: cover;
        position: relative;
        z-index: 0;
    }

    .contact-form-section::before {
        content: "";
        position: absolute;
        top: 0; left: 0;
        width: 100%; height: 100%;
        background: rgba(255, 255, 255, 0.85); /* white overlay */
        z-index: 0;
    }

    .contact-form-wrapper {
        position: relative;
        z-index: 1;
        background: #ffffff;
        border-top: 4px solid var(--primary);
        border-radius: 12px;
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.05);
    }

    .contact-info-section {
        background-color: #ffffff;
    }

    .contact-title,
    .section-title {
        font-weight: 700;
        color: #2c3e50;
        position: relative;
        padding-bottom: 15px;
    }

    .contact-title::after,
    .section-title::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 70px;
        height: 3px;
        background: var(--primary);
    }

    .contact-card {
        border: 1px solid rgba(0, 0, 0, 0.05);
        border-radius: 12px;
        background-color: #fff;
        transition: all 0.3s ease;
    }

    .contact-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 18px rgba(0, 0, 0, 0.08);
    }

    .contact-icon {
        width: 80px;
        height: 80px;
        background-color: var(--primary-light);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .form-control {
        border-radius: 8px;
        box-shadow: none;
        border: 1px solid #ced4da;
        transition: border-color 0.3s ease;
    }

    .form-control:focus {
        border-color: var(--primary);
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    }

    .btn-primary {
        background: var(--primary);
        border: none;
        border-radius: 50px;
        transition: all 0.3s ease;
    }

    .btn-primary:hover {
        background-color: #0b5ed7;
        transform: translateY(-2px);
        box-shadow: 0 6px 16px rgba(13, 110, 253, 0.3);
    }

    .invalid-feedback {
        color: #dc3545;
        font-size: 0.875em;
    }

    @media (max-width: 767.98px) {
        .contact-form-wrapper {
            padding: 2rem;
        }

        .contact-title,
        .section-title {
            font-size: 1.75rem;
        }
    }
</style>


<script>
    // Bootstrap validation
    (function () {
        'use strict';
        window.addEventListener('load', function () {
            var forms = document.getElementsByClassName('needs-validation');
            Array.prototype.filter.call(forms, function (form) {
                form.addEventListener('submit', function (event) {
                    if (form.checkValidity() === false) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        }, false);
    })();
</script>

@endsection




 --}}
