@extends('layouts.guest')

@section('title', 'Company Dashboard')

@section('content')
<style>
  @keyframes fade-slide {
    0% { opacity: 0; transform: translateY(-20px); }
    100% { opacity: 1; transform: translateY(0); }
  }
  .animate-fade-slide { animation: fade-slide 0.6s ease-out; }
</style>

<!-- DataTables CSS -->
<link href="https://cdn.jsdelivr.net/npm/simple-datatables@latest/dist/style.css" rel="stylesheet">

<div class="relative min-h-screen bg-cover bg-center" style="background-image: url('{{ asset('assests/image/home_evr2.jpeg') }}')">
  <div class="absolute inset-0 bg-black/50"></div>

  <div class="relative flex flex-col min-h-screen text-gray-900 animate-fade-slide">
    {{-- Topbar --}}
    <header class="bg-white bg-opacity-90 shadow sticky top-0 z-50">
      <div class="max-w-7xl mx-auto px-4 sm:px-6 py-4 flex justify-between items-center">
        <h1 class="text-2xl font-bold">Company Dashboard</h1>
        <form method="POST" action="{{ route('company.logout') }}">
          @csrf
          <button class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-md">Logout</button>
        </form>
      </div>
    </header>

    {{-- Main Content --}}
    <main class="flex-grow max-w-7xl mx-auto w-full px-4 sm:px-6 py-8 space-y-6">
      {{-- Welcome Card --}}
      <div class="bg-white bg-opacity-90 rounded-xl shadow p-6 flex justify-between items-center">
        <div>
          <h2 class="text-xl font-semibold">
            Welcome to the {{ optional(Auth::guard('company')->user())->name ?? 'Company' }} Dashboard
          </h2>
          <p class="text-gray-600">Manage employee complaints efficiently</p>
        </div>
        <a href="{{ route('complaints.create') }}"
           class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-md">
          + Register Complaint
        </a>
      </div>

      {{-- Complaints Table --}}
      <div class="bg-white bg-opacity-90 rounded-xl shadow p-6 space-y-4">
        <h3 class="text-lg font-bold">Complaints Registered by You</h3>

        @if($complaints->count())
          <div class="overflow-x-auto">
            <table id="complaintsTable" class="min-w-full divide-y divide-gray-200">
              <thead class="bg-gray-50">
                <tr>
                  <th>Emp ID</th>
                  <th>Name</th>
                  <th>Aadhaar</th>
                  <th>Reason</th>
                  <th>Docs</th>
                </tr>
              </thead>
              <tbody>
                @foreach($complaints as $c)
                <tr>
                  <td>{{ $c->employee_id }}</td>
                  <td>{{ "{$c->employee_name} {$c->father_name} {$c->surname}" }}</td>
                  <td>{{ $c->aadhar_id }}</td>
                  <td>{{ Str::limit($c->reason, 40) }}</td>
                  <td>
                    @if($c->termination_letter_path)
                      <a href="{{ asset('storage/' . $c->termination_letter_path) }}"
                         target="_blank" class="text-blue-600 hover:underline">View Letter</a>
                    @else
                      <span class="italic text-gray-500">Not available</span>
                    @endif
                  </td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        @else
          <div class="text-center p-6 text-yellow-800 bg-yellow-50 border border-yellow-200 rounded-lg">
            No complaints registered yet.
          </div>
        @endif
      </div>
    </main>
  </div>
</div>

<!-- Simple DataTables JS -->
<script src="https://cdn.jsdelivr.net/npm/simple-datatables@latest" defer></script>
<script>
  document.addEventListener("DOMContentLoaded", function() {
    const dataTable = new simpleDatatables.DataTable("#complaintsTable", {
      searchable: true, /* Enables search functionality */
      fixedHeight: true,
      perPage: 10,
      perPageSelect: [5,10,20]
    });

    // Tie only your custom input to the table
    document.getElementById("searchInput").addEventListener("input", function() {
      dataTable.search(this.value);
    });
  });
</script>
@endsection






























{{-- @extends('layouts.guest')

@section('title', 'Company Dashboard')

@section('content')
<div class="min-h-screen bg-gray-100 flex flex-col">

    <!--  Topbar - Mobile Responsive Header -->
    <header class="bg-white shadow sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 py-4 flex flex-col sm:flex-row sm:justify-between sm:items-center gap-2 sm:gap-0">
            <h1 class="text-xl sm:text-2xl font-bold text-gray-800 text-center sm:text-left">Company Dashboard</h1>
            <div class="flex justify-center sm:block">
                <form method="POST" action="{{ route('company.logout') }}">
                    @csrf
                    <button type="submit"
                            class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-md font-medium transition-colors duration-200">
                        Logout
                    </button>
                </form>
            </div>
        </div>
    </header>

    <!--  Main Content -->
    <main class="flex-grow max-w-7xl mx-auto w-full px-4 sm:px-6 py-8">

        <!-- Welcome Card -->
        <div class="bg-white rounded-xl shadow p-6 mb-6 w-full">
            <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
                <div>
                    <h2 class="text-xl font-semibold text-gray-800 mb-1">Welcome to the Company Dashboard</h2>
                    <p class="text-gray-600">Efficiently manage employee-related complaints</p>
                </div>

                <div class="w-full sm:w-auto">
                    <a href="{{ route('complaints.create') }}"
                       class="block w-full sm:w-auto bg-blue-600 hover:bg-blue-700 text-white font-semibold px-6 py-2 rounded-md shadow-sm text-center transition duration-200">
                        + Register Complaint
                    </a>
                </div>
            </div>
        </div>



        <!-- Complaints Table -->
        <div class="bg-white rounded-xl shadow p-4 sm:p-6">
            <h3 class="text-lg font-bold text-gray-700 mb-4 text-center sm:text-left">Complaints Registered by You</h3>

            @if($complaints->count() > 0)
                <div class="overflow-x-auto pb-2">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-100">
                            <tr>
                                <th class="px-4 py-2 sm:px-6 sm:py-3 text-left text-sm font-medium text-gray-700">Employee ID</th>
                                <th class="px-4 py-2 sm:px-6 sm:py-3 text-left text-sm font-medium text-gray-700">Name</th>
                                <th class="px-4 py-2 sm:px-6 sm:py-3 text-left text-sm font-medium text-gray-700">Aadhaar</th>
                                <th class="px-4 py-2 sm:px-6 sm:py-3 text-left text-sm font-medium text-gray-700">Reason</th>
                                <th class="px-4 py-2 sm:px-6 sm:py-3 text-left text-sm font-medium text-gray-700">Documents</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200 bg-white">
                            @foreach($complaints as $complaint)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-4 py-3 sm:px-6 sm:py-4 text-sm text-gray-800">{{ $complaint->employee_id }}</td>
                                    <td class="px-4 py-3 sm:px-6 sm:py-4 text-sm text-gray-800">{{ $complaint->employee_name }} {{ $complaint->father_name }} {{ $complaint->surname }}</td>
                                    <td class="px-4 py-3 sm:px-6 sm:py-4 text-sm text-gray-800">{{ $complaint->aadhar_id }}</td>
                                    <td class="px-4 py-3 sm:px-6 sm:py-4 text-sm text-gray-800 max-w-xs">{{ Str::limit($complaint->reason, 40) }}</td>
                                    <td class="px-4 py-3 sm:px-6 sm:py-4 text-sm">
                                        @if($complaint->termination_letter_path)
                                            <a href="{{ asset('termination/' . $complaint->termination_letter_path) }}"
                                               target="_blank"
                                               class="text-blue-600 hover:underline hover:text-blue-700">
                                                View Letter
                                            </a>
                                        @else
                                            <span class="text-gray-500 italic">Not available</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center p-6 text-yellow-800 bg-yellow-50 border border-yellow-200 rounded-lg">
                    No complaints registered by your company yet.
                </div>
            @endif
        </div>
    </main>
</div>
@endsection --}}
