@extends('layouts.guest')

@if ($errors->any())
    <div class="alert alert-danger mb-4">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif



@section('title', 'Edit Complaint')

@section('content')
<div class="min-h-screen bg-gray-100 flex flex-col py-8">

    {{-- Topbar --}}
    <header class="bg-white shadow sticky top-0 z-50">
        <div class="max-w-full mx-auto px-6 py-4 flex justify-center items-center">
            <h1 class="text-2xl font-bold text-gray-800 text-center">Edit Complaint</h1>
        </div>
    </header>

    {{-- Main Content --}}
    <main class="flex-grow max-w-full mx-auto w-full px-4 sm:px-6 lg:px-8 py-8">
        <div class="bg-white rounded-xl shadow p-6">
            <h2 class="text-xl font-semibold text-gray-800 mb-4">Update Complaint Details</h2>
            <form action="{{ route('complaints.update', $complaint->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT') <!-- HTTP PUT method for updating data -->

                <div class="space-y-4">
                    <!-- Employee ID (Read-only) -->
                    <div class="mb-4">
                        <label for="employee_id" class="form-label text-gray-700">Employee ID</label>
                        <input type="text" id="employee_id" name="employee_id" class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full" value="{{ old('employee_id', $complaint->employee_id) }}" required readonly>
                    </div>

                    <!-- Employee Name -->
                    <div class="mb-4">
                        <label for="employee_name" class="form-label text-gray-700">Employee Name</label>
                        <input type="text" id="employee_name" name="employee_name" class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full" value="{{ old('employee_name', $complaint->employee_name) }}" required>
                    </div>

                    <!-- Father's Name -->
                    <div class="mb-4">
                        <label for="father_name" class="form-label text-gray-700">Father's Name</label>
                        <input type="text" id="father_name" name="father_name" class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full" value="{{ old('father_name', $complaint->father_name) }}" required>
                    </div>

                    <!-- Surname -->
                    <div class="mb-4">
                        <label for="surname" class="form-label text-gray-700">Last Name</label>
                        <input type="text" id="surname" name="surname" class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full" value="{{ old('surname', $complaint->surname) }}" required>
                    </div>

                    <!-- Aadhar ID -->
                    <div class="mb-4">
                        <label for="aadhar_id" class="form-label text-gray-700">Aadhar ID</label>
                        <input type="text" id="aadhar_id" name="aadhar_id" class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full" value="{{ old('aadhar_id', $complaint->aadhar_id) }}" required>
                    </div>

                    <!-- Reason for Complaint -->
                    <div class="mb-4">
                        <label for="reason" class="form-label text-gray-700">Reason for Complaint</label>
                        <textarea id="reason" name="reason" class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full" rows="4" required>{{ old('reason', $complaint->reason) }}</textarea>
                    </div>

                    <!-- Termination Letter -->
                    <div class="mb-4">
                        <label for="termination_letter" class="form-label text-gray-700">Termination Letter (PDF)</label>
                        <input type="file" id="termination_letter" name="termination_letter" class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full" accept="application/pdf">
                        @if ($complaint->termination_letter_path)
                            <div class="mt-2 text-sm text-gray-500">
                                Current File: <a href="{{ asset('storage/' . $complaint->termination_letter_path) }}" target="_blank">View Termination Letter</a>
                            </div>
                        @endif
                    </div>

                    <!-- Submit Button -->
                    <div class="mt-6 text-center">
                        <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-semibold px-6 py-3 rounded-md shadow-sm transition">
                            Update Complaint
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </main>
</div>
@endsection
