@extends('layouts.guest')

@section('title', 'Register Complaint')

@section('content')
<style>
    @keyframes fadeSlide {
        0% {
            opacity: 0;
            transform: translateY(-20px);
        }
        100% {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .animated-form {
        animation: fadeSlide 0.8s ease-out;
    }
</style>

<div class="min-h-screen bg-cover bg-center flex flex-col py-8"
     style="background-image: url('{{ asset('assests/image/complaints_evr.jpg') }}');">

    {{-- Topbar --}}
    {{-- <header class="bg-white bg-opacity-90 shadow sticky top-0 z-50">
        <div class="max-w-full mx-auto px-6 py-4 flex justify-center items-center">
            <h1 class="text-2xl font-bold text-gray-800 text-center">Register Complaint</h1>
        </div>
    </header> --}}

    {{-- Main Content --}}
    <main class="flex-grow max-w-3xl mx-auto w-full px-4 sm:px-6 lg:px-8 py-8">
        <div class="bg-white bg-opacity-95 rounded-xl shadow p-6 animated-form">
            <h1 class="text-2xl font-bold text-gray-800 text-center">Register Complaint</h1>
            <br>
            <h2 class="text-xl font-semibold text-gray-800 mb-4 text-center">Please Fill Out the Complaint Form</h2>
            <form action="{{ route('complaints.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="space-y-4">

                    {{-- Employee ID --}}
                    <div class="mb-4">
                        <label for="employee_id" class="form-label text-gray-700">Employee ID</label>
                        <input type="text" id="employee_id" name="employee_id"
                               class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full" required>
                    </div>

                    {{-- Employee Name --}}
                    <div class="mb-4">
                        <label for="employee_name" class="form-label text-gray-700">Employee Name</label>
                        <input type="text" id="employee_name" name="employee_name"
                               class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full" required>
                    </div>

                    {{-- Father's Name --}}
                    <div class="mb-4">
                        <label for="father_name" class="form-label text-gray-700">Father's Name</label>
                        <input type="text" id="father_name" name="father_name"
                               class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full" required>
                    </div>

                    {{-- Last Name --}}
                    <div class="mb-4">
                        <label for="surname" class="form-label text-gray-700">Last Name</label>
                        <input type="text" id="surname" name="surname"
                               class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full" required>
                    </div>

                    {{-- Aadhar ID --}}
                    <div class="mb-4">
                        <label for="aadhar_id" class="form-label text-gray-700">Aadhar ID</label>
                        <input type="text" id="aadhar_id" name="aadhar_id"
                               class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full" required>
                    </div>

                    {{-- Reason for Complaint --}}
                    <div class="mb-4">
                        <label for="reason" class="form-label text-gray-700">Reason for Complaint</label>
                        <textarea id="reason" name="reason"
                                  class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full"
                                  rows="4" required></textarea>
                    </div>

                    {{-- Termination Letter (PDF) --}}
                    <div class="mb-4">
                        <label for="termination_letter" class="form-label text-gray-700">Termination Letter (PDF)</label>
                        <input type="file" id="termination_letter" name="termination_letter"
                               class="form-control mt-2 p-3 border border-gray-300 rounded-md w-full"
                               accept="application/pdf" required>
                    </div>

                    {{-- Submit Button --}}
                    <div class="mt-6 text-center">
                        <button type="submit"
                                class="bg-blue-600 hover:bg-blue-700 text-white font-semibold px-6 py-3 rounded-md shadow-sm transition">
                            Submit Complaint
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </main>
</div>
@endsection







