@extends('layouts.guest')

@section('content')
<style>
    @keyframes slideFromTop {
        0% {
            transform: translateY(-30px);
            opacity: 0;
        }
        100% {
            transform: translateY(0);
            opacity: 1;
        }
    }

    .slide-in {
        animation: slideFromTop 0.8s ease-out;
    }
</style>

<div class="min-h-screen flex items-center justify-center bg-cover bg-center"
     style="background-image: url('{{ asset('assests/image/home_evr3.jpg') }}');">
    <div class="max-w-md w-full bg-white bg-opacity-90 p-8 rounded-lg shadow-md mt-10 slide-in">
        <h2 class="text-2xl font-bold text-gray-800 mb-6 text-center">Company Registration</h2>

        <form method="POST" action="{{ route('company.register') }}">
            @csrf

            <!-- Company Name -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-semibold mb-2">Company Name</label>
                <input type="text" name="name" value="{{ old('name') }}"
                       class="w-full px-4 py-2 border rounded-lg @error('name') border-red-500 @enderror"
                       required autofocus>
                @error('name')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Email Address -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-semibold mb-2">Email Address</label>
                <input type="email" name="email" value="{{ old('email') }}"
                       class="w-full px-4 py-2 border rounded-lg @error('email') border-red-500 @enderror"
                       required>
                @error('email')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Password -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-semibold mb-2">Password</label>
                <input type="password" name="password"
                       class="w-full px-4 py-2 border rounded-lg @error('password') border-red-500 @enderror"
                       required>
                @error('password')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Confirm Password -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-semibold mb-2">Confirm Password</label>
                <input type="password" name="password_confirmation"
                       class="w-full px-4 py-2 border rounded-lg"
                       required>
            </div>

            <!-- Registration Number -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-semibold mb-2">Registration Number</label>
                <input type="text" name="registration_number" value="{{ old('registration_number') }}"
                       class="w-full px-4 py-2 border rounded-lg @error('registration_number') border-red-500 @enderror"
                       required>
                @error('registration_number')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- PAN Number -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-semibold mb-2">PAN Number</label>
                <input type="text" name="pancard" value="{{ old('pancard') }}"
                       class="w-full px-4 py-2 border rounded-lg @error('pancard') border-red-500 @enderror"
                       required>
                @error('pancard')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Address -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-semibold mb-2">Address</label>
                <textarea name="address"
                          class="w-full px-4 py-2 border rounded-lg @error('address') border-red-500 @enderror"
                          required>{{ old('address') }}</textarea>
                @error('address')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Contact Number -->
            <div class="mb-6">
                <label class="block text-gray-700 text-sm font-semibold mb-2">Contact Number</label>
                <input type="text" name="contact" value="{{ old('contact') }}"
                       class="w-full px-4 py-2 border rounded-lg @error('contact') border-red-500 @enderror"
                       required>
                @error('contact')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <button type="submit"
                    class="w-full bg-blue-600 text-white py-2 px-4 rounded-lg hover:bg-blue-700 transition duration-200">
                Register
            </button>
        </form>

        <div class="mt-4 text-center">
            <p class="text-gray-600">Already registered?
                <a href="{{ route('company.login') }}" class="text-blue-600 hover:underline">Login here</a>
            </p>
        </div>
    </div>
</div>
@endsection


{{-- @extends('layouts.guest')

@section('content')
<div class="max-w-md mx-auto bg-white p-8 rounded-lg shadow-md mt-10">
    <h2 class="text-2xl font-bold text-gray-800 mb-6 text-center">Company Registration</h2>

    <form method="POST" action="{{ route('company.register') }}">
        @csrf

        <!-- Company Name -->
        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-semibold mb-2">Company Name</label>
            <input type="text" name="name" value="{{ old('name') }}"
                   class="w-full px-4 py-2 border rounded-lg @error('name') border-red-500 @enderror"
                   required autofocus>
            @error('name')
                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
            @enderror
        </div>

        <!-- Email Address -->
        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-semibold mb-2">Email Address</label>
            <input type="email" name="email" value="{{ old('email') }}"
                   class="w-full px-4 py-2 border rounded-lg @error('email') border-red-500 @enderror"
                   required>
            @error('email')
                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
            @enderror
        </div>

        <!-- Password -->
        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-semibold mb-2">Password</label>
            <input type="password" name="password"
                   class="w-full px-4 py-2 border rounded-lg @error('password') border-red-500 @enderror"
                   required>
            @error('password')
                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
            @enderror
        </div>

        <!-- Confirm Password -->
        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-semibold mb-2">Confirm Password</label>
            <input type="password" name="password_confirmation"
                   class="w-full px-4 py-2 border rounded-lg"
                   required>
        </div>

        <!-- Registration Number -->
        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-semibold mb-2">Registration Number</label>
            <input type="text" name="registration_number" value="{{ old('registration_number') }}"
                   class="w-full px-4 py-2 border rounded-lg @error('registration_number') border-red-500 @enderror"
                   required>
            @error('registration_number')
                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
            @enderror
        </div>


        <!-- PAN Number -->
        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-semibold mb-2">PAN Number</label>
            <input type="text" name="pancard" value="{{ old('pancard') }}"
                   class="w-full px-4 py-2 border rounded-lg @error('pancard') border-red-500 @enderror"
                   required>
            @error('pancard')
                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
            @enderror
        </div>


        <!-- Address -->
        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-semibold mb-2">Address</label>
            <textarea name="address"
                      class="w-full px-4 py-2 border rounded-lg @error('address') border-red-500 @enderror"
                      required>{{ old('address') }}</textarea>
            @error('address')
                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
            @enderror
        </div>

        <!-- Contact Number -->
        <div class="mb-6">
            <label class="block text-gray-700 text-sm font-semibold mb-2">Contact Number</label>
            <input type="text" name="contact" value="{{ old('contact') }}"
                   class="w-full px-4 py-2 border rounded-lg @error('contact') border-red-500 @enderror"
                   required>
            @error('contact')
                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
            @enderror
        </div>

        <button type="submit"
                class="w-full bg-blue-600 text-white py-2 px-4 rounded-lg hover:bg-blue-700 transition duration-200">
            Register
        </button>
    </form>

    <div class="mt-4 text-center">
        <p class="text-gray-600">Already registered?
            <a href="{{ route('company.login') }}" class="text-blue-600 hover:underline">Login here</a>
        </p>
    </div>
</div>
@endsection --}}
