@extends('layouts.guest')

@section('content')
<style>
    @keyframes slideFromTop {
        0% {
            transform: translateY(-40px);
            opacity: 0;
        }
        100% {
            transform: translateY(0);
            opacity: 1;
        }
    }

    .fade-slide {
        animation: slideFromTop 0.8s ease-out;
    }
</style>

<div class="relative min-h-screen flex items-center justify-center bg-cover bg-center"
     style="background-image: url('{{ asset('assests/image/home_evr2.jpeg') }}');">

    <!-- Dark Overlay -->
    <div class="absolute inset-0 bg-black opacity-50"></div>

    <!-- Login Card -->
    <div class="relative z-10 w-full max-w-md mx-auto bg-white p-8 rounded-lg shadow-md fade-slide">
        <h2 class="text-2xl font-bold text-gray-800 mb-6 text-center">Company Login</h2>

        <form method="POST" action="{{ route('company.login') }}">
            @csrf

            <!-- Email Address -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-semibold mb-2">Email Address</label>
                <input type="email" name="email" value="{{ old('email') }}"
                       class="w-full px-4 py-2 border rounded-lg @error('email') border-red-500 @enderror"
                       required autofocus>
                @error('email')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Password -->
            <div class="mb-6">
                <label class="block text-gray-700 text-sm font-semibold mb-2">Password</label>
                <input type="password" name="password"
                       class="w-full px-4 py-2 border rounded-lg @error('password') border-red-500 @enderror"
                       required>
                @error('password')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <button type="submit"
                    class="w-full bg-blue-600 text-white py-2 px-4 rounded-lg hover:bg-blue-700 transition duration-200">
                Login
            </button>
        </form>

        <div class="mt-4 text-center">
            <p class="text-gray-600">Don't have an account?
                <a href="{{ route('company.register') }}" class="text-blue-600 hover:underline">Register here</a>
            </p>
        </div>
    </div>
</div>
@endsection







{{-- @extends('layouts.guest')

@section('content')
<div class="max-w-md mx-auto bg-white p-8 rounded-lg shadow-md mt-10">
    <h2 class="text-2xl font-bold text-gray-800 mb-6 text-center">Company Login</h2>

    <form method="POST" action="{{ route('company.login') }}">
        @csrf

        <!-- Email Address -->
        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-semibold mb-2">Email Address</label>
            <input type="email" name="email" value="{{ old('email') }}"
                   class="w-full px-4 py-2 border rounded-lg @error('email') border-red-500 @enderror"
                   required autofocus>
            @error('email')
                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
            @enderror
        </div>

        <!-- Password -->
        <div class="mb-6">
            <label class="block text-gray-700 text-sm font-semibold mb-2">Password</label>
            <input type="password" name="password"
                   class="w-full px-4 py-2 border rounded-lg @error('password') border-red-500 @enderror"
                   required>
            @error('password')
                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
            @enderror
        </div>

        <button type="submit"
                class="w-full bg-blue-600 text-white py-2 px-4 rounded-lg hover:bg-blue-700 transition duration-200">
            Login
        </button>
    </form>

    <div class="mt-4 text-center">
        <p class="text-gray-600">Don't have an account?
            <a href="{{ route('company.register') }}" class="text-blue-600 hover:underline">Register here</a>
        </p>
    </div>
</div>
@endsection --}}
