@extends('Frontend.master')
@section('content')

<div class="content">
    <!-- Hero Section with Gradient Background -->
    <div class="hero-section py-5" style="background: linear-gradient(135deg, #f5f7fa 0%, #e4e8ed 100%);">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 mb-4 mb-md-0">
                    <img src="{{ asset('assests/image/about_evr.png') }}"
                         alt="Termination Verification Platform"
                         class="img-fluid rounded shadow">
                </div>
                <div class="col-lg-6 col-md-6">
                    <h2 class="gradient-text text-4xl w-full text-white font-extrabold bg-gradient-to-r from-blue-600 to-green-500">                    About Our
                    <br />Termination Registry
                    </h2>
                    <p class="lead text-dark mb-4">
                        Secure platform for companies to register and verify employee termination records
                    </p>
                    <div class="d-flex align-items-center mb-3">
                        <i class="fas fa-check-circle text-success mr-2"></i>
                        <span>Company registration with KYC verification</span>
                    </div>
                    <div class="d-flex align-items-center mb-3">
                        <i class="fas fa-check-circle text-success mr-2"></i>
                        <span>Termination reporting with evidence upload</span>
                    </div>
                    <div class="d-flex align-items-center">
                        <i class="fas fa-check-circle text-success mr-2"></i>
                        <span>Instant name-based search system</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- How It Works Section with Pattern Background -->
    <div class="py-5" style="background-color: #f8f9fa; background-image: radial-gradient(#e3e5e8 1px, transparent 1px); background-size: 20px 20px;">
        <div class="container">
            <div class="text-center mb-5">
                {{-- <h2 class="mb-3">Our Process</h2> --}}
                <h2 class="gradient-text text-4xl w-full text-white font-extrabold bg-gradient-to-r from-blue-600 to-green-500">Our Process</h2>
                <div class="divider mx-auto bg-primary"></div>
            </div>

            <div class="row g-4">
                <!-- Step 1 -->
                <div class="col-lg-4 col-md-6">
                    <div class="process-card h-100 text-center p-4 bg-white rounded shadow-sm" style="border-top: 4px solid #0d6efd;">
                        <div class="process-icon mb-3">
                            <div class="icon-bg bg-primary-light">
                                <i class="fas fa-building fa-2x text-primary"></i>
                            </div>
                        </div>
                        <h3 class="h4 mb-3">1. Company Registration</h3>
                        <div class="process-content">
                            <p>Businesses complete KYC verification to gain access to the termination registry system.</p>
                            <div class="text-start mt-3 ps-3">
                                <div class="d-flex mb-2">
                                    <i class="fas fa-check-circle text-success mt-1 me-2"></i>
                                    <span>Company validation</span>
                                </div>
                                <div class="d-flex mb-2">
                                    <i class="fas fa-check-circle text-success mt-1 me-2"></i>
                                    <span>Admin account setup</span>
                                </div>
                                <div class="d-flex">
                                    <i class="fas fa-check-circle text-success mt-1 me-2"></i>
                                    <span>Secure access credentials</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 2 -->
                <div class="col-lg-4 col-md-6">
                    <div class="process-card h-100 text-center p-4 bg-white rounded shadow-sm" style="border-top: 4px solid #dc3545;">
                        <div class="process-icon mb-3">
                            <div class="icon-bg bg-danger-light">
                                <i class="fas fa-user-slash fa-2x text-danger"></i>
                            </div>
                        </div>
                        <h3 class="h4 mb-3">2. Termination Reporting</h3>
                        <div class="process-content">
                            <p>HR teams submit verified termination records with mandatory evidence.</p>
                            <div class="text-start mt-3 ps-3">
                                <div class="d-flex mb-2">
                                    <i class="fas fa-arrow-right text-muted mt-1 me-2"></i>
                                    <span>Full legal name</span>
                                </div>
                                <div class="d-flex mb-2">
                                    <i class="fas fa-arrow-right text-muted mt-1 me-2"></i>
                                    <span>Termination reason code</span>
                                </div>
                                <div class="d-flex">
                                    <i class="fas fa-arrow-right text-muted mt-1 me-2"></i>
                                    <span>Documentation upload</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 3 -->
                <div class="col-lg-4 col-md-6">
                    <div class="process-card h-100 text-center p-4 bg-white rounded shadow-sm" style="border-top: 4px solid #198754;">
                        <div class="process-icon mb-3">
                            <div class="icon-bg bg-success-light">
                                <i class="fas fa-search fa-2x text-success"></i>
                            </div>
                        </div>
                        <h3 class="h4 mb-3">3. Secure Verification</h3>
                        <div class="process-content">
                            <p>Authorized employers search the registry with name components.</p>
                            <div class="text-start mt-3 ps-3">
                                <div class="d-flex mb-2">
                                    <i class="fas fa-search-minus text-muted mt-1 me-2"></i>
                                    <span>First/Middle/Last name</span>
                                </div>
                                <div class="d-flex mb-2">
                                    <i class="fas fa-id-card text-muted mt-1 me-2"></i>
                                    <span>ID verification</span>
                                </div>
                                <div class="d-flex">
                                    <i class="fas fa-ban text-danger mt-1 me-2"></i>
                                    <span>No Data Found (if clean)</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Why Our System Works Section with Gradient Background -->
    <div class="hero-section py-5" style="background: linear-gradient(135deg, #f5f7fa 0%, #e4e8ed 100%);">

        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center mb-5">
                    <h2 class="gradient-text text-4xl w-full text-white font-extrabold bg-gradient-to-r from-blue-600 to-green-500">Why Our System Works</h2>                    <div class="divider mx-auto bg-primary"></div>
                    <p class="lead mt-3">This proven process delivers several key benefits:</p>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-6">
                    <!-- Data Integrity Card -->
                    <div class="feature-card p-4 mb-4 bg-white rounded shadow-sm" style="border-left: 4px solid #0d6efd;">
                        <div class="d-flex align-items-start">
                            <div class="me-4 pt-1">
                                <i class="fas fa-shield-alt fa-2x text-primary"></i>
                            </div>
                            <div>
                                <h4 class="mt-0 mb-2">Data Integrity</h4>
                                <p class="mb-0">All termination submissions require documented proof to prevent false claims.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Legal Compliance Card -->
                    <div class="feature-card p-4 mb-4 bg-white rounded shadow-sm" style="border-left: 4px solid #6f42c1;">
                        <div class="d-flex align-items-start">
                            <div class="me-4 pt-1">
                                <i class="fas fa-balance-scale fa-2x text-primary"></i>
                            </div>
                            <div>
                                <h4 class="mt-0 mb-2">Legal Compliance</h4>
                                <p class="mb-0">Strict adherence to labor laws - only factual, verified termination data is stored.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Privacy Protection Card -->
                    <div class="feature-card p-4 bg-white rounded shadow-sm" style="border-left: 4px solid #20c997;">
                        <div class="d-flex align-items-start">
                            <div class="me-4 pt-1">
                                <i class="fas fa-eye-slash fa-2x text-primary"></i>
                            </div>
                            <div>
                                <h4 class="mt-0 mb-2">Privacy Protection</h4>
                                <p class="mb-0">Sensitive details are masked - only authorized users see full records.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <!-- Two-Way Verification Card -->
                    <div class="feature-card p-4 mb-4 bg-white rounded shadow-sm" style="border-left: 4px solid #fd7e14;">
                        <div class="d-flex align-items-start">
                            <div class="me-4 pt-1">
                                <i class="fas fa-random fa-2x text-primary"></i>
                            </div>
                            <div>
                                <h4 class="mt-0 mb-2">Two-Way Verification</h4>
                                <p class="mb-0">Companies can contest inaccurate records through our dispute resolution system.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Audit Trail Card -->
                    <div class="feature-card p-4 mb-4 bg-white rounded shadow-sm" style="border-left: 4px solid #d63384;">
                        <div class="d-flex align-items-start">
                            <div class="me-4 pt-1">
                                <i class="fas fa-history fa-2x text-primary"></i>
                            </div>
                            <div>
                                <h4 class="mt-0 mb-2">Audit Trail</h4>
                                <p class="mb-0">Every search and submission is logged for accountability. Provide complete transparency for all registry activities.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Industry-Wide Coverage Card -->
                    <div class="feature-card p-4 bg-white rounded shadow-sm" style="border-left: 4px solid #0dcaf0;">
                        <div class="d-flex align-items-start">
                            <div class="me-4 pt-1">
                                <i class="fas fa-globe fa-2x text-primary"></i>
                            </div>
                            <div>
                                <h4 class="mt-0 mb-2">Industry-Wide Coverage</h4>
                                <p class="mb-0">Growing network of participating employers across sectors.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- User Types Section with Diagonal Background -->
    <div class="py-5" style="background-color: #f8f9fa; background-image: radial-gradient(#e3e5e8 1px, transparent 1px); background-size: 20px 20px;">

        <div class="container">
            <div class="text-center mb-5">
                <h2 class="gradient-text text-4xl w-full text-white font-extrabold bg-gradient-to-r from-blue-600 to-green-500">Who Uses This System?</h2>
                <div class="divider mx-auto bg-primary"></div>
            </div>
            <div class="row">
                <div class="col-lg-6 mb-4">
                    <div class="user-card p-4 h-100 bg-white rounded shadow-sm">
                        <div class="d-flex align-items-center mb-3">
                            <i class="fas fa-building fa-2x text-primary me-3"></i>
                            <h3 class="mb-0">Reporting Companies</h3>
                        </div>
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="fas fa-check-circle text-success mr-2"></i> Register terminated employees confidentially</li>
                            <li class="mb-2"><i class="fas fa-check-circle text-success mr-2"></i> Reduce risk of re-hiring problematic former staff</li>
                            <li><i class="fas fa-check-circle text-success mr-2"></i> Contribute to industry-wide hiring standards</li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-6 mb-4">
                    <div class="user-card p-4 h-100 bg-white rounded shadow-sm">
                        <div class="d-flex align-items-center mb-3">
                            <i class="fas fa-search fa-2x text-primary me-3"></i>
                            <h3 class="mb-0">Hiring Employers</h3>
                        </div>
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="fas fa-check-circle text-success mr-2"></i> Verify candidates' termination history</li>
                            <li class="mb-2"><i class="fas fa-check-circle text-success mr-2"></i> Make informed hiring decisions</li>
                            <li><i class="fas fa-check-circle text-success mr-2"></i> Protect company culture and assets</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    /* General Styling */
    .content {
        overflow-x: hidden;
    }

    .divider {
        width: 60px;
        height: 3px;
    }

    /* Hero Section */
    .hero-section {
        position: relative;
        overflow: hidden;
    }

    .hero-section::before {
        content: "";
        position: absolute;
        top: -50px;
        right: -50px;
        width: 200px;
        height: 200px;
        background: rgba(13, 110, 253, 0.1);
        border-radius: 50%;
        z-index: 0;
    }

    .hero-section::after {
        content: "";
        position: absolute;
        bottom: -30px;
        left: -30px;
        width: 150px;
        height: 150px;
        background: rgba(25, 135, 84, 0.1);
        border-radius: 50%;
        z-index: 0;
    }

    /* Process Section Styling */
    .process-card {
        transition: all 0.3s ease;
        border: 1px solid rgba(0,0,0,0.05);
        position: relative;
        overflow: hidden;
        z-index: 1;
    }

    .process-card::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, rgba(255,255,255,0.9) 0%, rgba(248,249,250,0.9) 100%);
        z-index: -1;
    }

    .process-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    }

    .process-icon .icon-bg {
        width: 70px;
        height: 70px;
        margin: 0 auto;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .bg-primary-light {
        background-color: rgba(13, 110, 253, 0.1);
    }
    .bg-danger-light {
        background-color: rgba(220, 53, 69, 0.1);
    }
    .bg-success-light {
        background-color: rgba(25, 135, 84, 0.1);
    }

    /* Feature Cards */
    .feature-card {
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .feature-card::after {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(to bottom right, rgba(255,255,255,0.8), rgba(248,249,250,0.8));
        z-index: -1;
    }

    .feature-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }

    /* User Cards */
    .user-card {
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .user-card::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, rgba(255,255,255,0.9) 0%, rgba(248,249,250,0.9) 100%);
        z-index: -1;
    }

    .user-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }

    /* User Types Section */
    .user-types-section {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        position: relative;
        overflow: hidden;
    }

    .user-types-section::before {
        content: "";
        position: absolute;
        top: 0;
        right: 0;
        width: 300px;
        height: 300px;
        background: rgba(13, 110, 253, 0.05);
        border-radius: 50%;
        z-index: 0;
    }

    .user-types-section::after {
        content: "";
        position: absolute;
        bottom: 0;
        left: 0;
        width: 200px;
        height: 200px;
        background: rgba(25, 135, 84, 0.05);
        border-radius: 50%;
        z-index: 0;
    }

    .bg-subtle-pattern {
        background-image: radial-gradient(rgba(0,0,0,0.05) 1px, transparent 1px);
        background-size: 20px 20px;
    }


    h2 {
    font-size: 28px;
    font-weight: 800;
    margin: 0;
    }

    h2.gradient-text {
    background: -webkit-linear-gradient(45deg, #09009f, #00ff95 80%);
    -webkit-background-clip: text; /* apply background clip */
    -webkit-text-fill-color: transparent;
    }


    /* Responsive Adjustments */
    @media (max-width: 767.98px) {
        .process-content {
            min-height: auto !important;
        }

        .hero-section::before,
        .hero-section::after,
        .user-types-section::before,
        .user-types-section::after {
            display: none;
        }
    }


</style>

@endsection













{{-- @extends('Frontend.master')
@section('content')

<div class="content">
    <!-- Hero Section -->
    <div class="container py-5">
        <div class="row justify-content-center align-items-center">
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 mb-4 mb-md-0">
                <img src="{{ asset('assests/image/about_evr.png') }}"
                     alt="Termination Verification Platform"
                     class="img-fluid rounded shadow">
            </div>
            <div class="col-lg-6 col-md-6">
                <h1 class="mb-3">About Our Termination Registry</h1>
                <p class="lead text-dark mb-4">
                    Secure platform for companies to register and verify employee termination records
                </p>
                <div class="d-flex align-items-center mb-3">
                    <i class="fas fa-check-circle text-success mr-2"></i>
                    <span>Company registration with KYC verification</span>
                </div>
                <div class="d-flex align-items-center mb-3">
                    <i class="fas fa-check-circle text-success mr-2"></i>
                    <span>Termination reporting with evidence upload</span>
                </div>
                <div class="d-flex align-items-center">
                    <i class="fas fa-check-circle text-success mr-2"></i>
                    <span>Instant name-based search system</span>
                </div>
            </div>
        </div>
    </div>

    <!-- How It Works Section -->
    <div class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="mb-3">Our Process</h2>
                <div class="divider mx-auto bg-primary"></div>
            </div>

            <div class="row g-4">
                <!-- Step 1 -->
                <div class="col-lg-4 col-md-6">
                    <div class="process-card h-100 text-center p-4 bg-white rounded shadow-sm">
                        <div class="process-icon mb-3">
                            <div class="icon-bg bg-primary-light">
                                <i class="fas fa-building fa-2x text-primary"></i>
                            </div>
                        </div>
                        <h3 class="h4 mb-3">1. Company Registration</h3>
                        <div class="process-content">
                            <p>Businesses complete KYC verification to gain access to the termination registry system.</p>
                            <div class="text-start mt-3 ps-3">
                                <div class="d-flex mb-2">
                                    <i class="fas fa-check-circle text-success mt-1 me-2"></i>
                                    <span>Company validation</span>
                                </div>
                                <div class="d-flex mb-2">
                                    <i class="fas fa-check-circle text-success mt-1 me-2"></i>
                                    <span>Admin account setup</span>
                                </div>
                                <div class="d-flex">
                                    <i class="fas fa-check-circle text-success mt-1 me-2"></i>
                                    <span>Secure access credentials</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 2 -->
                <div class="col-lg-4 col-md-6">
                    <div class="process-card h-100 text-center p-4 bg-white rounded shadow-sm">
                        <div class="process-icon mb-3">
                            <div class="icon-bg bg-danger-light">
                                <i class="fas fa-user-slash fa-2x text-danger"></i>
                            </div>
                        </div>
                        <h3 class="h4 mb-3">2. Termination Reporting</h3>
                        <div class="process-content">
                            <p>HR teams submit verified termination records with mandatory evidence.</p>
                            <div class="text-start mt-3 ps-3">
                                <div class="d-flex mb-2">
                                    <i class="fas fa-arrow-right text-muted mt-1 me-2"></i>
                                    <span>Full legal name</span>
                                </div>
                                <div class="d-flex mb-2">
                                    <i class="fas fa-arrow-right text-muted mt-1 me-2"></i>
                                    <span>Termination reason code</span>
                                </div>
                                <div class="d-flex">
                                    <i class="fas fa-arrow-right text-muted mt-1 me-2"></i>
                                    <span>Documentation upload</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 3 -->
                <div class="col-lg-4 col-md-6">
                    <div class="process-card h-100 text-center p-4 bg-white rounded shadow-sm">
                        <div class="process-icon mb-3">
                            <div class="icon-bg bg-success-light">
                                <i class="fas fa-search fa-2x text-success"></i>
                            </div>
                        </div>
                        <h3 class="h4 mb-3">3. Secure Verification</h3>
                        <div class="process-content">
                            <p>Authorized employers search the registry with name components.</p>
                            <div class="text-start mt-3 ps-3">
                                <div class="d-flex mb-2">
                                    <i class="fas fa-search-minus text-muted mt-1 me-2"></i>
                                    <span>First/Middle/Last name</span>
                                </div>
                                <div class="d-flex mb-2">
                                    <i class="fas fa-id-card text-muted mt-1 me-2"></i>
                                    <span>ID verification</span>
                                </div>
                                <div class="d-flex">
                                    <i class="fas fa-ban text-danger mt-1 me-2"></i>
                                    <span>No Data Found (if clean)</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Why Our System Works Section -->
    <div class="container py-5">
        <div class="row">
            <div class="col-lg-12 text-center mb-5">
                <h2>Why Our System Works</h2>
                <div class="divider mx-auto bg-primary"></div>
                <p class="lead mt-3">This proven process delivers several key benefits:</p>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-6">
                <!-- Data Integrity Card -->
                <div class="feature-card p-4 mb-4 bg-white rounded shadow-sm">
                    <div class="d-flex align-items-start">
                        <div class="me-4 pt-1">
                            <i class="fas fa-shield-alt fa-2x text-primary"></i>
                        </div>
                        <div>
                            <h4 class="mt-0 mb-2">Data Integrity</h4>
                            <p class="mb-0">All termination submissions require documented proof to prevent false claims.</p>
                        </div>
                    </div>
                </div>

                <!-- Legal Compliance Card -->
                <div class="feature-card p-4 mb-4 bg-white rounded shadow-sm">
                    <div class="d-flex align-items-start">
                        <div class="me-4 pt-1">
                            <i class="fas fa-balance-scale fa-2x text-primary"></i>
                        </div>
                        <div>
                            <h4 class="mt-0 mb-2">Legal Compliance</h4>
                            <p class="mb-0">Strict adherence to labor laws - only factual, verified termination data is stored.</p>
                        </div>
                    </div>
                </div>

                <!-- Privacy Protection Card -->
                <div class="feature-card p-4 bg-white rounded shadow-sm">
                    <div class="d-flex align-items-start">
                        <div class="me-4 pt-1">
                            <i class="fas fa-eye-slash fa-2x text-primary"></i>
                        </div>
                        <div>
                            <h4 class="mt-0 mb-2">Privacy Protection</h4>
                            <p class="mb-0">Sensitive details are masked - only authorized users see full records.</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <!-- Two-Way Verification Card -->
                <div class="feature-card p-4 mb-4 bg-white rounded shadow-sm">
                    <div class="d-flex align-items-start">
                        <div class="me-4 pt-1">
                            <i class="fas fa-random fa-2x text-primary"></i>
                        </div>
                        <div>
                            <h4 class="mt-0 mb-2">Two-Way Verification</h4>
                            <p class="mb-0">Companies can contest inaccurate records through our dispute resolution system.</p>
                        </div>
                    </div>
                </div>

                <!-- Audit Trail Card -->
                <div class="feature-card p-4 mb-4 bg-white rounded shadow-sm">
                    <div class="d-flex align-items-start">
                        <div class="me-4 pt-1">
                            <i class="fas fa-history fa-2x text-primary"></i>
                        </div>
                        <div>
                            <h4 class="mt-0 mb-2">Audit Trail</h4>
                            <p class="mb-0">Every search and submission is logged for accountability. Provide complete transparency for all registry activities.</p>
                        </div>
                    </div>
                </div>

                <!-- Industry-Wide Coverage Card -->
                <div class="feature-card p-4 bg-white rounded shadow-sm">
                    <div class="d-flex align-items-start">
                        <div class="me-4 pt-1">
                            <i class="fas fa-globe fa-2x text-primary"></i>
                        </div>
                        <div>
                            <h4 class="mt-0 mb-2">Industry-Wide Coverage</h4>
                            <p class="mb-0">Growing network of participating employers across sectors.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- User Types Section -->
    <div class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="mb-3">Who Uses This System?</h2>
                <div class="divider mx-auto bg-primary"></div>
            </div>
            <div class="row">
                <div class="col-lg-6 mb-4">
                    <div class="user-card p-4 h-100 bg-white rounded shadow-sm">
                        <div class="d-flex align-items-center mb-3">
                            <i class="fas fa-building fa-2x text-primary mr-3"></i>
                            <h3 class="mb-0">Reporting Companies</h3>
                        </div>
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="fas fa-check-circle text-success mr-2"></i> Register terminated employees confidentially</li>
                            <li class="mb-2"><i class="fas fa-check-circle text-success mr-2"></i> Reduce risk of re-hiring problematic former staff</li>
                            <li><i class="fas fa-check-circle text-success mr-2"></i> Contribute to industry-wide hiring standards</li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-6 mb-4">
                    <div class="user-card p-4 h-100 bg-white rounded shadow-sm">
                        <div class="d-flex align-items-center mb-3">
                            <i class="fas fa-search fa-2x text-primary mr-3"></i>
                            <h3 class="mb-0">Hiring Employers</h3>
                        </div>
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="fas fa-check-circle text-success mr-2"></i> Verify candidates' termination history</li>
                            <li class="mb-2"><i class="fas fa-check-circle text-success mr-2"></i> Make informed hiring decisions</li>
                            <li><i class="fas fa-check-circle text-success mr-2"></i> Protect company culture and assets</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    /* General Styling */
    .content {
        overflow-x: hidden;
    }

    .divider {
        width: 60px;
        height: 3px;
    }

    /* Process Section Styling */
    .process-card {
        transition: all 0.3s ease;
        border: 1px solid rgba(0,0,0,0.05);
    }
    .process-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    }

    .process-icon .icon-bg {
        width: 70px;
        height: 70px;
        margin: 0 auto;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .bg-primary-light {
        background-color: rgba(13, 110, 253, 0.1);
    }
    .bg-danger-light {
        background-color: rgba(220, 53, 69, 0.1);
    }
    .bg-success-light {
        background-color: rgba(25, 135, 84, 0.1);
    }

    /* Feature Cards */
    .feature-card {
        transition: all 0.3s ease;
        border-left: 3px solid transparent;
    }
    .feature-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        border-left: 3px solid var(--bs-primary);
    }

    /* User Cards */
    .user-card {
        transition: all 0.3s ease;
    }
    .user-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }

    /* Responsive Adjustments */
    @media (max-width: 767.98px) {
        .process-content {
            min-height: auto !important;
        }
    }
</style>

@endsection
 --}}
