<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('complaints', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->unsignedBigInteger('employee_id');
            $table->string('employee_name');
            $table->string('father_name');
            $table->string('surname');
            $table->string('aadhar_id');
            $table->text('reason');
            $table->string('termination_letter_path')->nullable(); // PDF स्टोर करने के लिए
            $table->enum('status', ['pending', 'under_review', 'resolved'])->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('complaints');
    }
};
