<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Complaint extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'employee_id',
        'employee_name',
        'father_name',
        'surname', 
        'aadhar_id',
        'reason',
        'termination_letter_path',
        'status'
    ];
    
    // Add accessor for full name
    public function getFullNameAttribute()
    {
        return "{$this->employee_name} {$this->father_name} {$this->surname}";
    }
    
    // Relationship with company
    public function company()
    {
        return $this->belongsTo(Company::class);
    }
    
    // Relationship with employee
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

}

