<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Razorpay\Api\Api;
use Session;

class RazorpayController extends Controller
{
    public function initiatePayment(Request $request)
    {
        $request->validate([
            'employee_name' => 'required',
            'father_name' => 'required',
            'surname' => 'required',
        ]);

        $data = $request->only(['employee_name', 'father_name', 'surname']);
        session($data); // Store for post-payment search

        $api = new Api(env('RAZORPAY_KEY'), env('RAZORPAY_SECRET'));

        $orderData = [
            'receipt' => uniqid(),
            'amount' => 10000, // ₹1 in paise add 00 for 100
            'currency' => 'INR',
        ];

        $order = $api->order->create($orderData);

        return view('payment.checkout', [
            'order' => $order,
            'key' => env('RAZORPAY_KEY')
        ]);
    }

    public function paymentSuccess(Request $request)
    {
        // Now search complaints
        $employee_name = session('employee_name');
        $father_name = session('father_name');
        $surname = session('surname');

        $complaints = \App\Models\Complaint::where([
            ['employee_name', $employee_name],
            ['father_name', $father_name],
            ['surname', $surname],
        ])->get();

        return view('Frontend.pages.Company.complaints.search', compact('complaints'));
    }
}
