<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Company;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;



class CompanyAuthController extends Controller
{
    // Show Registration Form
    public function showRegistrationForm()
    {
        return view('Frontend.pages.Company.auth.register');
    }

    // Handle Registration
    public function register(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:companies',
            'password' => 'required|string|min:6|confirmed',
            'registration_number' => 'required|string|unique:companies',
            'address' => 'required|string',
            'pancard' => 'required|regex:/^[A-Z]{5}[0-9]{4}[A-Z]{1}$/',
            'contact' => 'required|string|max:15'
        ]);

        Company::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'registration_number' => $request->registration_number,
            'pancard' => $request->pancard,
            'address' => $request->address,
            'contact' => $request->contact
        ]);


        // Redirect to dashboard
        return redirect()->route('company.dashboard');

        return response()->json(['message' => 'Company registered successfully'], 201);

    }

    // Show Login Form
    public function showLoginForm()
    {
        return view('Frontend.pages.Company.auth.login');
    }

    // Handle Login
    public function login(Request $request)
    {
        $credentials = $request->validate([
            'email' => 'required|email',
            'password' => 'required'
        ]);

        if (auth()->guard('company')->attempt($credentials)) {
            return redirect()->route('company.dashboard');
        }

        return back()->withErrors(['email' => 'Invalid credentials']);
    }

    // Handle Logout
    public function logout()
    {
        auth()->guard('company')->logout();
        return redirect('/');
    }
}
